/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.doubleinsert;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.test.embedded.doubleinsert.Contact;

@Entity
@Indexed
@Table(name="T_ADDRESS")
public class Address
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="A_ADDRESS_ID")
    @DocumentId
    private long id;
    @Column(name="A_ADDRESS1")
    @Field(index=Index.TOKENIZED, store=Store.YES)
    private String address1;
    @Column(name="A_ADDRESS2")
    @Field(index=Index.TOKENIZED, store=Store.YES)
    private String address2;
    @Column(name="A_TOWN")
    @Field(index=Index.TOKENIZED, store=Store.YES)
    private String town;
    @Column(name="A_COUNTY")
    @Field(index=Index.TOKENIZED, store=Store.YES)
    private String county;
    @Column(name="A_COUNTRY")
    @Field(index=Index.TOKENIZED, store=Store.YES)
    private String country;
    @Column(name="A_POSTCODE")
    @Field(index=Index.TOKENIZED, store=Store.YES)
    private String postcode;
    @Column(name="A_ACTIVE")
    @Type(type="boolean")
    private boolean active;
    @Column(name="A_CREATEDON")
    @Type(type="java.util.Date")
    private Date createdOn;
    @Column(name="A_LASTUPDATEDON")
    @Type(type="java.util.Date")
    private Date lastUpdatedOn;
    @ManyToOne
    @JoinColumn(name="C_CONTACT_ID")
    @IndexedEmbedded
    private Contact contact;

    public Address(String address1, String address2, String town, String county, String country, String postcode, boolean active, Contact contact) {
        this.address1 = address1;
        this.address2 = address2;
        this.town = town;
        this.county = county;
        this.country = country;
        this.postcode = postcode;
        this.active = active;
        this.contact = contact;
    }

    public Address() {
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public String getAddress2() {
        if (null == this.address2 || "".equals(this.address2)) {
            return "N/A";
        }
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public String getTown() {
        return this.town;
    }

    public void setTown(String town) {
        this.town = town;
    }

    public String getCounty() {
        if (null == this.county || "".equals(this.county)) {
            return "N/A";
        }
        return this.county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        this.lastUpdatedOn = lastUpdatedOn;
    }

    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Address)) {
            return false;
        }
        Address that = (Address)object;
        if (!this.equals(this.getAddress1(), that.getAddress1())) {
            return false;
        }
        if (!this.equals(this.getAddress2(), that.getAddress2())) {
            return false;
        }
        if (!this.equals(this.getCounty(), that.getCounty())) {
            return false;
        }
        if (!this.equals(this.getTown(), that.getTown())) {
            return false;
        }
        if (!this.equals(this.getPostcode(), that.getPostcode())) {
            return false;
        }
        return this.equals(this.getContact(), that.getContact());
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o1.equals(o2));
    }

    private int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public int hashCode() {
        int a = 13;
        a = a * 23 + this.hashCode(this.getAddress1());
        a = a * 23 + this.hashCode(this.getAddress2());
        a = a * 23 + this.hashCode(this.getCounty());
        a = a * 23 + this.hashCode(this.getTown());
        a = a * 23 + this.hashCode(this.getPostcode());
        a = a * 23 + this.hashCode(this.getContact());
        return a;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.displayAddress(buf, this);
        return buf.toString();
    }

    private void displayAddress(StringBuilder buf, Address address) {
    }

    public boolean isValidPostcode() {
        return false;
    }
}

