/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.search.batchindexing.SessionAwareRunnable;
import org.hibernate.search.batchindexing.StatelessSessionAwareRunnable;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.transaction.TransactionFactory;
import org.slf4j.Logger;

public class OptionallyWrapInJTATransaction
implements Runnable {
    private static final Logger log = LoggerFactory.make();
    private final SessionFactoryImplementor factory;
    private final SessionAwareRunnable sessionAwareRunnable;
    private final StatelessSessionAwareRunnable statelessSessionAwareRunnable;

    public OptionallyWrapInJTATransaction(SessionFactory factory, SessionAwareRunnable sessionAwareRunnable) {
        this.factory = (SessionFactoryImplementor)factory;
        this.sessionAwareRunnable = sessionAwareRunnable;
        this.statelessSessionAwareRunnable = null;
    }

    public OptionallyWrapInJTATransaction(SessionFactory factory, StatelessSessionAwareRunnable statelessSessionAwareRunnable) {
        this.factory = (SessionFactoryImplementor)factory;
        this.sessionAwareRunnable = null;
        this.statelessSessionAwareRunnable = statelessSessionAwareRunnable;
    }

    public void run() {
        block13: {
            boolean wrapInTransaction = this.wrapInTransaction();
            if (wrapInTransaction) {
                TransactionManager transactionManager = this.factory.getTransactionManager();
                try {
                    StatelessSession statelessSession;
                    org.hibernate.classic.Session session;
                    if (this.sessionAwareRunnable != null) {
                        session = this.factory.openSession();
                        statelessSession = null;
                    } else {
                        session = null;
                        statelessSession = this.factory.openStatelessSession();
                    }
                    transactionManager.begin();
                    if (this.sessionAwareRunnable != null) {
                        this.sessionAwareRunnable.run((Session)session);
                    } else {
                        this.statelessSessionAwareRunnable.run(statelessSession);
                    }
                    transactionManager.commit();
                    if (this.sessionAwareRunnable != null) {
                        session.close();
                        break block13;
                    }
                    statelessSession.close();
                }
                catch (Throwable e) {
                    log.error("Error while executing runnable wrapped in a JTA transaction", e);
                    try {
                        this.factory.getTransactionManager().rollback();
                    }
                    catch (SystemException e1) {
                        log.error("Error while rollbacking transaction after " + e.getMessage(), (Throwable)e1);
                    }
                }
            } else if (this.sessionAwareRunnable != null) {
                this.sessionAwareRunnable.run(null);
            } else {
                this.statelessSessionAwareRunnable.run(null);
            }
        }
    }

    boolean wrapInTransaction() {
        TransactionFactory transactionFactory = this.factory.getSettings().getTransactionFactory();
        if (!transactionFactory.isTransactionManagerRequired()) {
            log.trace("TransactionFactory does not require a TransactionManager: don't wrap in a JTA transaction");
            return false;
        }
        TransactionManager transactionManager = this.factory.getTransactionManager();
        if (transactionManager == null) {
            log.trace("No TransactionManager found, do not start a surrounding JTA transaction");
            return false;
        }
        try {
            if (transactionManager.getStatus() == 6) {
                log.trace("No Transaction in progress, needs to start a JTA transaction");
                return true;
            }
        }
        catch (SystemException e) {
            log.warn("Cannot guess the Transaction Status: not starting a JTA transaction", (Throwable)e);
            return false;
        }
        log.trace("Transaction in progress, no needs to start a JTA transaction");
        return false;
    }
}

