/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.search.Filter;
import org.hibernate.search.query.dsl.PhraseContext;
import org.hibernate.search.query.dsl.PhraseMatchingContext;
import org.hibernate.search.query.dsl.impl.ConnectedPhraseMatchingContext;
import org.hibernate.search.query.dsl.impl.PhraseQueryContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;

class ConnectedPhraseContext
implements PhraseContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer = new QueryCustomizer();
    private final PhraseQueryContext phraseContext = new PhraseQueryContext();

    public ConnectedPhraseContext(QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
    }

    public PhraseContext withSlop(int slop) {
        this.phraseContext.setSlop(slop);
        return this;
    }

    public PhraseMatchingContext onField(String fieldName) {
        return new ConnectedPhraseMatchingContext(fieldName, this.phraseContext, this.queryCustomizer, this.queryContext);
    }

    public PhraseContext boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    public PhraseContext withConstantScore() {
        this.queryCustomizer.withConstantScore();
        return this;
    }

    public PhraseContext filteredBy(Filter filter) {
        this.queryCustomizer.filteredBy(filter);
        return this;
    }
}

