/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.hibernate.search.query.fieldcache.FieldLoadingStrategy;

public final class StringFieldLoadingStrategy
implements FieldLoadingStrategy {
    private final String fieldName;
    private String[] currentCache;

    public StringFieldLoadingStrategy(String fieldName) {
        this.fieldName = fieldName;
    }

    public void loadNewCacheValues(IndexReader reader) throws IOException {
        this.currentCache = FieldCache.DEFAULT.getStrings(reader, this.fieldName);
    }

    public String collect(int relativeDocId) {
        return this.currentCache[relativeDocId];
    }
}

