/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store;

import java.io.Serializable;
import java.util.Properties;
import org.apache.lucene.document.Document;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.IndexShardingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdHashShardingStrategy
implements IndexShardingStrategy {
    private DirectoryProvider<?>[] providers;

    @Override
    public void initialize(Properties properties, DirectoryProvider<?>[] providers) {
        this.providers = providers;
    }

    @Override
    public DirectoryProvider<?>[] getDirectoryProvidersForAllShards() {
        return this.providers;
    }

    @Override
    public DirectoryProvider<?> getDirectoryProviderForAddition(Class<?> entity, Serializable id, String idInString, Document document) {
        return this.providers[this.hashKey(idInString)];
    }

    @Override
    public DirectoryProvider<?>[] getDirectoryProvidersForDeletion(Class<?> entity, Serializable id, String idInString) {
        if (idInString == null) {
            return this.providers;
        }
        return new DirectoryProvider[]{this.providers[this.hashKey(idInString)]};
    }

    @Override
    public DirectoryProvider<?>[] getDirectoryProvidersForQuery(FullTextFilterImplementor[] fullTextFilters) {
        return this.getDirectoryProvidersForAllShards();
    }

    private int hashKey(String key) {
        int hash = 0;
        int length = key.length();
        for (int index = 0; index < length; ++index) {
            hash = 31 * hash + key.charAt(index);
        }
        return Math.abs(hash % this.providers.length);
    }
}

