/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.util.Properties;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PostCollectionRecreateEvent;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEvent;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEvent;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.search.event.EventListenerRegister;
import org.hibernate.search.event.FullTextIndexEventListener;
import org.junit.Assert;
import org.junit.Test;

public class EventListenerRegisterTest {
    @Test
    public void testRegisterOnEmptyListeners_CfgDisabled() {
        EventListeners evListeners = new EventListeners();
        EventListenerRegister.enableHibernateSearch((EventListeners)evListeners, (Properties)EventListenerRegisterTest.makeConfiguration(false));
        EventListenerRegister.enableHibernateSearch((EventListeners)evListeners, (Properties)EventListenerRegisterTest.makeConfiguration(false));
        this.assertPresence(false, evListeners);
    }

    @Test
    public void testRegisterOnEmptyListeners_CfgEnabled() {
        EventListeners evListeners = new EventListeners();
        EventListenerRegister.enableHibernateSearch((EventListeners)evListeners, (Properties)EventListenerRegisterTest.makeConfiguration(true));
        EventListenerRegister.enableHibernateSearch((EventListeners)evListeners, (Properties)EventListenerRegisterTest.makeConfiguration(true));
        this.assertPresence(true, evListeners);
    }

    @Test
    public void testRegisterOnEmptyListeners_CfgAuto() {
        EventListeners evListeners = new EventListeners();
        EventListenerRegister.enableHibernateSearch((EventListeners)evListeners, (Properties)new Properties());
        EventListenerRegister.enableHibernateSearch((EventListeners)evListeners, (Properties)new Properties());
        this.assertPresence(true, evListeners);
    }

    @Test
    public void testOnAlreadyRegistered() {
        this.helperOnAlreadyRegistered(new FullTextIndexEventListener(FullTextIndexEventListener.Installation.SINGLE_INSTANCE));
    }

    @Test
    public void testOnPopulatedEventListeners() {
        EventListeners evListeners = this.makeSomeEventListeners();
        EventListenerRegister.enableHibernateSearch((EventListeners)evListeners, (Properties)new Properties());
        EventListenerRegister.enableHibernateSearch((EventListeners)evListeners, (Properties)new Properties());
        this.assertPresence(true, evListeners);
    }

    private void helperOnAlreadyRegistered(FullTextIndexEventListener listenerFullText) {
        AnotherListener listenerA = new AnotherListener();
        AnotherListener listenerB = new AnotherListener();
        EventListeners evListeners = new EventListeners();
        evListeners.setPostInsertEventListeners(new PostInsertEventListener[]{listenerA, listenerB, listenerFullText});
        evListeners.setPostUpdateEventListeners(new PostUpdateEventListener[]{listenerA, listenerB, listenerFullText});
        evListeners.setPostDeleteEventListeners(new PostDeleteEventListener[]{listenerA, listenerB, listenerFullText});
        evListeners.setPostCollectionRecreateEventListeners(new PostCollectionRecreateEventListener[]{listenerA, listenerB, listenerFullText});
        evListeners.setPostCollectionRemoveEventListeners(new PostCollectionRemoveEventListener[]{listenerA, listenerB, listenerFullText});
        evListeners.setPostCollectionUpdateEventListeners(new PostCollectionUpdateEventListener[]{listenerA, listenerB, listenerFullText});
        EventListenerRegister.enableHibernateSearch((EventListeners)evListeners, (Properties)EventListenerRegisterTest.makeConfiguration(false));
        EventListenerRegister.enableHibernateSearch((EventListeners)evListeners, (Properties)EventListenerRegisterTest.makeConfiguration(false));
        EventListenerRegister.enableHibernateSearch((EventListeners)evListeners, (Properties)EventListenerRegisterTest.makeConfiguration(false));
        this.assertPresence(true, evListeners);
    }

    private EventListeners makeSomeEventListeners() {
        AnotherListener listenerA = new AnotherListener();
        AnotherListener listenerB = new AnotherListener();
        AnotherListener listenerC = new AnotherListener();
        EventListeners evListeners = new EventListeners();
        evListeners.setPostInsertEventListeners(new PostInsertEventListener[]{listenerA, listenerB, listenerC});
        evListeners.setPostUpdateEventListeners(new PostUpdateEventListener[]{listenerA, listenerB, listenerC});
        evListeners.setPostDeleteEventListeners(new PostDeleteEventListener[]{listenerA, listenerB, listenerC});
        evListeners.setPostCollectionRecreateEventListeners(new PostCollectionRecreateEventListener[]{listenerA, listenerB, listenerC});
        evListeners.setPostCollectionRemoveEventListeners(new PostCollectionRemoveEventListener[]{listenerA, listenerB, listenerC});
        evListeners.setPostCollectionUpdateEventListeners(new PostCollectionUpdateEventListener[]{listenerA, listenerB, listenerC});
        return evListeners;
    }

    private void assertPresence(boolean expected, EventListeners evListeners) {
        Assert.assertEquals((Object)expected, (Object)EventListenerRegisterTest.isPresent(evListeners.getPostInsertEventListeners()));
        Assert.assertEquals((Object)expected, (Object)EventListenerRegisterTest.isPresent(evListeners.getPostUpdateEventListeners()));
        Assert.assertEquals((Object)expected, (Object)EventListenerRegisterTest.isPresent(evListeners.getPostDeleteEventListeners()));
        Assert.assertEquals((Object)expected, (Object)EventListenerRegisterTest.isPresent(evListeners.getPostCollectionRecreateEventListeners()));
        Assert.assertEquals((Object)expected, (Object)EventListenerRegisterTest.isPresent(evListeners.getPostCollectionRemoveEventListeners()));
        Assert.assertEquals((Object)expected, (Object)EventListenerRegisterTest.isPresent(evListeners.getPostCollectionUpdateEventListeners()));
    }

    private static Properties makeConfiguration(boolean enableSearch) {
        Properties p = new Properties();
        p.setProperty("hibernate.search.autoregister_listeners", String.valueOf(enableSearch));
        return p;
    }

    private static boolean isPresent(Object[] listeners) {
        if (listeners == null) {
            return false;
        }
        boolean found = false;
        for (Object eventListener : listeners) {
            if (FullTextIndexEventListener.class != eventListener.getClass()) continue;
            Assert.assertFalse((boolean)found);
            found = true;
        }
        return found;
    }

    private static class AnotherListener
    implements PostDeleteEventListener,
    PostInsertEventListener,
    PostUpdateEventListener,
    PostCollectionRecreateEventListener,
    PostCollectionRemoveEventListener,
    PostCollectionUpdateEventListener {
        private AnotherListener() {
        }

        public void onPostDelete(PostDeleteEvent event) {
        }

        public void onPostInsert(PostInsertEvent event) {
        }

        public void onPostUpdate(PostUpdateEvent event) {
        }

        public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        }

        public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        }

        public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        }
    }
}

