/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.boost;

import java.util.List;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.query.boost.BoostedDescriptionLibrary;
import org.hibernate.search.test.query.boost.BoostedFieldDescriptionLibrary;
import org.hibernate.search.test.query.boost.BoostedGetDescriptionLibrary;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldBoostTest
extends SearchTestCase {
    private static final Logger log = LoggerFactory.make();

    public void testBoostedGetDesc() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        this.buildBoostedGetIndex(fullTextSession);
        fullTextSession.clear();
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser authorParser = new QueryParser(FieldBoostTest.getTargetLuceneVersion(), "author", SearchTestCase.standardAnalyzer);
        QueryParser descParser = new QueryParser(FieldBoostTest.getTargetLuceneVersion(), "description", SearchTestCase.standardAnalyzer);
        Query author = authorParser.parse("Wells");
        Query desc = descParser.parse("martians");
        BooleanQuery query = new BooleanQuery();
        query.add(author, BooleanClause.Occur.SHOULD);
        query.add(desc, BooleanClause.Occur.SHOULD);
        log.debug(query.toString());
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery((Query)query, new Class[]{BoostedGetDescriptionLibrary.class});
        List results = hibQuery.list();
        log.debug(hibQuery.explain(0).toString());
        log.debug(hibQuery.explain(1).toString());
        FieldBoostTest.assertTrue((String)"incorrect document returned", (boolean)((BoostedGetDescriptionLibrary)results.get(0)).getDescription().startsWith("Martians"));
        for (Object element : fullTextSession.createQuery("from " + BoostedGetDescriptionLibrary.class.getName()).list()) {
            fullTextSession.delete(element);
        }
        tx.commit();
        fullTextSession.close();
    }

    public void testBoostedFieldDesc() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        this.buildBoostedFieldIndex(fullTextSession);
        fullTextSession.clear();
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser authorParser = new QueryParser(FieldBoostTest.getTargetLuceneVersion(), "author", SearchTestCase.standardAnalyzer);
        QueryParser descParser = new QueryParser(FieldBoostTest.getTargetLuceneVersion(), "description", SearchTestCase.standardAnalyzer);
        Query author = authorParser.parse("Wells");
        Query desc = descParser.parse("martians");
        BooleanQuery query = new BooleanQuery();
        query.add(author, BooleanClause.Occur.SHOULD);
        query.add(desc, BooleanClause.Occur.SHOULD);
        log.debug(query.toString());
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery((Query)query, new Class[]{BoostedFieldDescriptionLibrary.class});
        List results = hibQuery.list();
        FieldBoostTest.assertTrue((String)"incorrect document boost", (boolean)((BoostedFieldDescriptionLibrary)results.get(0)).getDescription().startsWith("Martians"));
        log.debug(hibQuery.explain(0).toString());
        log.debug(hibQuery.explain(1).toString());
        for (Object element : fullTextSession.createQuery("from " + BoostedFieldDescriptionLibrary.class.getName()).list()) {
            fullTextSession.delete(element);
        }
        tx.commit();
        fullTextSession.close();
    }

    public void testBoostedDesc() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        this.buildBoostedDescIndex(fullTextSession);
        fullTextSession.clear();
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser authorParser = new QueryParser(FieldBoostTest.getTargetLuceneVersion(), "author", SearchTestCase.standardAnalyzer);
        QueryParser descParser = new QueryParser(FieldBoostTest.getTargetLuceneVersion(), "description", SearchTestCase.standardAnalyzer);
        Query author = authorParser.parse("Wells");
        Query desc = descParser.parse("martians");
        BooleanQuery query = new BooleanQuery();
        query.add(author, BooleanClause.Occur.SHOULD);
        query.add(desc, BooleanClause.Occur.SHOULD);
        log.debug(query.toString());
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery((Query)query, new Class[]{BoostedDescriptionLibrary.class});
        List results = hibQuery.list();
        log.debug(hibQuery.explain(0).toString());
        log.debug(hibQuery.explain(1).toString());
        FieldBoostTest.assertTrue((String)"incorrect document returned", (boolean)((BoostedDescriptionLibrary)results.get(0)).getDescription().startsWith("Martians"));
        for (Object element : fullTextSession.createQuery("from " + BoostedDescriptionLibrary.class.getName()).list()) {
            fullTextSession.delete(element);
        }
        tx.commit();
        fullTextSession.close();
    }

    private void buildBoostedDescIndex(FullTextSession session) {
        Transaction tx = session.beginTransaction();
        BoostedDescriptionLibrary l = new BoostedDescriptionLibrary();
        l.setAuthor("H.G. Wells");
        l.setTitle("The Invisible Man");
        l.setDescription("Scientist discovers invisibility and becomes insane.");
        session.save((Object)l);
        l = new BoostedDescriptionLibrary();
        l.setAuthor("H.G. Wells");
        l.setTitle("War of the Worlds");
        l.setDescription("Martians invade earth to eliminate mankind.");
        session.save((Object)l);
        tx.commit();
    }

    private void buildBoostedFieldIndex(FullTextSession session) {
        Transaction tx = session.beginTransaction();
        BoostedFieldDescriptionLibrary l = new BoostedFieldDescriptionLibrary();
        l.setAuthor("H.G. Wells");
        l.setTitle("The Invisible Man");
        l.setDescription("Scientist discovers invisibility and becomes insane.");
        session.save((Object)l);
        l = new BoostedFieldDescriptionLibrary();
        l.setAuthor("H.G. Wells");
        l.setTitle("War of the Worlds");
        l.setDescription("Martians invade earth to eliminate mankind.");
        session.save((Object)l);
        tx.commit();
    }

    private void buildBoostedGetIndex(FullTextSession session) {
        Transaction tx = session.beginTransaction();
        BoostedGetDescriptionLibrary l = new BoostedGetDescriptionLibrary();
        l.setAuthor("H.G. Wells");
        l.setTitle("The Invisible Man");
        l.setDescription("Scientist discovers invisibility and becomes insane.");
        session.save((Object)l);
        l = new BoostedGetDescriptionLibrary();
        l.setAuthor("H.G. Wells");
        l.setTitle("War of the Worlds");
        l.setDescription("Martians invade earth to eliminate mankind.");
        session.save((Object)l);
        tx.commit();
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{BoostedDescriptionLibrary.class, BoostedFieldDescriptionLibrary.class, BoostedGetDescriptionLibrary.class};
    }
}

