/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.session;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.context.ThreadLocalSessionContext;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.session.DelegationWrapper;
import org.hibernate.search.test.session.Domain;
import org.hibernate.search.test.session.Email;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionTest
extends SearchTestCase {
    private static final Class[] SESS_PROXY_INTERFACES = new Class[]{org.hibernate.classic.Session.class, SessionImplementor.class, JDBCContext.Context.class, EventSource.class};

    public void testSessionWrapper() throws Exception {
        Session s = this.openSession();
        DelegationWrapper wrapper = new DelegationWrapper(s);
        Session wrapped = (Session)Proxy.newProxyInstance(org.hibernate.classic.Session.class.getClassLoader(), SESS_PROXY_INTERFACES, (InvocationHandler)wrapper);
        try {
            Search.getFullTextSession((Session)wrapped);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            SessionTest.fail((String)e.toString());
        }
        wrapped.close();
    }

    public void testDetachedCriteria() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        DetachedCriteria dc = DetachedCriteria.forClass(Email.class);
        try {
            Criteria c = dc.getExecutableCriteria((Session)s).setMaxResults(10);
            c.list();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            SessionTest.fail((String)e.toString());
        }
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testThreadBoundSessionWrappingOutOfTransaction() throws Exception {
        org.hibernate.classic.Session session = this.getSessions().getCurrentSession();
        try {
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        }
        finally {
            ThreadLocalSessionContext.unbind((SessionFactory)this.getSessions());
        }
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Email.class, Domain.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.connection.autocommit", "true");
        cfg.setProperty("hibernate.current_session_context_class", "thread");
    }
}

