/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import org.hibernate.HibernateException;
import org.hibernate.search.SearchException;
import org.hibernate.search.test.directoryProvider.CustomLockFactoryFactory;
import org.hibernate.search.test.directoryProvider.SnowStorm;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.Assert;
import org.junit.Test;

public class CustomLockProviderTest {
    @Test
    public void testUseOfCustomLockingFactory() {
        Assert.assertNull((Object)CustomLockFactoryFactory.optionValue);
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        builder.addAnnotatedClass(SnowStorm.class).setProperty("hibernate.search.default.locking_option", "somethingHere").setProperty("hibernate.search.default.locking_strategy", "org.hibernate.search.test.directoryProvider.CustomLockFactoryFactory").build();
        builder.close();
        Assert.assertEquals((Object)"somethingHere", (Object)CustomLockFactoryFactory.optionValue);
    }

    @Test
    public void testFailOnInexistentLockingFactory() {
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        try {
            builder.addAnnotatedClass(SnowStorm.class).setProperty("hibernate.search.default.locking_option", "somethingHere").setProperty("hibernate.search.default.locking_strategy", "org.hibernate.NotExistingFactory").build();
            builder.close();
            Assert.fail();
        }
        catch (HibernateException e) {
            Throwable causeSearch = e.getCause();
            Assert.assertNotNull((Object)causeSearch);
            Assert.assertTrue((boolean)(causeSearch instanceof SearchException));
            Assert.assertEquals((Object)"Unable to find locking_strategy implementation class: org.hibernate.NotExistingFactory", (Object)causeSearch.getMessage());
        }
    }
}

