/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.fieldoncollection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.test.embedded.fieldoncollection.CollectionItem;
import org.hibernate.search.test.embedded.fieldoncollection.CollectionItemFieldBridge;
import org.hibernate.search.test.embedded.fieldoncollection.CollectionOfStringsFieldBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Indexed
public class IndexedEntity {
    public static final String FIELD1_FIELD_NAME = "field1";
    public static final String FIELD2_FIELD_NAME = "field2";
    @Id
    @GeneratedValue
    @DocumentId
    private Integer id;
    @Field
    private String name;
    @ManyToMany(targetEntity=CollectionItem.class)
    @JoinTable(name="indexedentity_collectionitem_field")
    @Field(bridge=@FieldBridge(impl=CollectionItemFieldBridge.class), index=Index.UN_TOKENIZED)
    private List<CollectionItem> itemsWithFieldAnnotation = new ArrayList<CollectionItem>();
    @ManyToMany(targetEntity=CollectionItem.class)
    @JoinTable(name="indexedentity_collectionitem_fields")
    @Fields(value={@Field(name="field1", bridge=@FieldBridge(impl=CollectionItemFieldBridge.class), index=Index.UN_TOKENIZED), @Field(name="field2", bridge=@FieldBridge(impl=CollectionItemFieldBridge.class), index=Index.UN_TOKENIZED)})
    private List<CollectionItem> itemsWithFieldsAnnotation = new ArrayList<CollectionItem>();
    @ElementCollection
    @Column(name="keyword")
    @CollectionTable(name="indexedentity_keyword", joinColumns={@JoinColumn(name="indexedentity")})
    @Field(bridge=@FieldBridge(impl=CollectionOfStringsFieldBridge.class), index=Index.UN_TOKENIZED, store=Store.YES)
    private Set<String> keywords = new HashSet<String>();

    public IndexedEntity() {
    }

    public IndexedEntity(String name) {
        this.name = name;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<CollectionItem> getItemsWithFieldAnnotation() {
        return this.itemsWithFieldAnnotation;
    }

    public void setItemsWithFieldAnnotation(List<CollectionItem> items) {
        this.itemsWithFieldAnnotation.clear();
        for (CollectionItem item : items) {
            this.addItemsWithFieldAnnotation(item);
        }
    }

    public void addItemsWithFieldAnnotation(CollectionItem item) {
        if (!this.itemsWithFieldAnnotation.contains(item)) {
            this.itemsWithFieldAnnotation.add(item);
        }
    }

    public List<CollectionItem> getItemsWithFieldsAnnotation() {
        return this.itemsWithFieldsAnnotation;
    }

    public void setItemsWithFieldsAnnotation(List<CollectionItem> items) {
        this.itemsWithFieldsAnnotation.clear();
        for (CollectionItem item : items) {
            this.addItemsWithFieldsAnnotation(item);
        }
    }

    public void addItemsWithFieldsAnnotation(CollectionItem item) {
        if (!this.itemsWithFieldsAnnotation.contains(item)) {
            this.itemsWithFieldsAnnotation.add(item);
        }
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Set<String> keywords) {
        this.keywords.clear();
        for (String keyword : keywords) {
            this.addKeyword(keyword);
        }
    }

    public void addKeyword(String keyword) {
        this.keywords.add(keyword);
    }
}

