/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.OpenBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndDocIdSet
extends DocIdSet {
    private DocIdSet docIdBitSet;
    private final List<DocIdSet> andedDocIdSets;
    private final int maxDocNumber;

    public AndDocIdSet(List<DocIdSet> andedDocIdSets, int maxDocs) {
        if (andedDocIdSets == null || andedDocIdSets.size() < 2) {
            throw new IllegalArgumentException("To \"and\" some DocIdSet(s) they should be at least 2");
        }
        this.andedDocIdSets = new ArrayList<DocIdSet>(andedDocIdSets);
        this.maxDocNumber = maxDocs;
    }

    public DocIdSetIterator iterator() throws IOException {
        return this.buildBitSet().iterator();
    }

    public boolean isCacheable() {
        return true;
    }

    private synchronized DocIdSet buildBitSet() throws IOException {
        if (this.docIdBitSet != null) {
            return this.docIdBitSet;
        }
        int size = this.andedDocIdSets.size();
        DocIdSetIterator[] iterators = new DocIdSetIterator[size];
        for (int i = 0; i < size; ++i) {
            DocIdSetIterator docIdSetIterator = this.andedDocIdSets.get(i).iterator();
            if (docIdSetIterator == null) {
                return DocIdSet.EMPTY_DOCIDSET;
            }
            iterators[i] = docIdSetIterator;
        }
        this.andedDocIdSets.clear();
        this.docIdBitSet = this.makeDocIdSetOnAgreedBits(iterators);
        return this.docIdBitSet;
    }

    private DocIdSet makeDocIdSetOnAgreedBits(DocIdSetIterator[] iterators) throws IOException {
        OpenBitSet result = new OpenBitSet((long)this.maxDocNumber);
        int numberOfIterators = iterators.length;
        int targetPosition = this.findFirstTargetPosition(iterators, result);
        if (targetPosition == Integer.MAX_VALUE) {
            return DocIdSet.EMPTY_DOCIDSET;
        }
        int i = 0;
        int votes = 0;
        while (true) {
            DocIdSetIterator iterator = iterators[i];
            int position = ++targetPosition;
            if (!this.iteratorAlreadyOnTargetPosition(targetPosition, iterator)) {
                position = iterator.advance(targetPosition);
            }
            if (position == Integer.MAX_VALUE) {
                return result;
            }
            if (position == targetPosition) {
                if (++votes == numberOfIterators) {
                    result.fastSet(position);
                    votes = 0;
                }
            } else {
                votes = 1;
                targetPosition = position;
            }
            ++i;
            i %= numberOfIterators;
        }
    }

    private boolean iteratorAlreadyOnTargetPosition(int targetPosition, DocIdSetIterator iterator) {
        return iterator.docID() == targetPosition;
    }

    private int findFirstTargetPosition(DocIdSetIterator[] iterators, OpenBitSet result) throws IOException {
        int targetPosition = iterators[0].nextDoc();
        if (targetPosition == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        boolean allIteratorsShareSameFirstTarget = true;
        for (int i = 1; i < iterators.length; ++i) {
            DocIdSetIterator iterator = iterators[i];
            int position = iterator.nextDoc();
            if (position == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (targetPosition == position) continue;
            targetPosition = Math.max(targetPosition, position);
            allIteratorsShareSameFirstTarget = false;
        }
        if (allIteratorsShareSameFirstTarget) {
            result.fastSet(targetPosition);
            ++targetPosition;
        }
        return targetPosition;
    }
}

