/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.compression;

import java.util.List;
import java.util.zip.DataFormatException;
import junit.framework.Assert;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.hibernate.Session;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.compression.LargeDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompressionTest
extends SearchTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFieldWasCompressed() throws Exception {
        DirectoryProvider[] directoryProviders = this.getSearchFactory().getDirectoryProviders(LargeDocument.class);
        IndexReader indexReader = this.getSearchFactory().getReaderProvider().openReader(directoryProviders);
        try {
            IndexSearcher searcher = new IndexSearcher(indexReader);
            TopDocs topDocs = searcher.search((Query)new MatchAllDocsQuery(), null, 10);
            Assert.assertEquals((int)1, (int)topDocs.totalHits);
            ScoreDoc doc = topDocs.scoreDocs[0];
            Document document = indexReader.document(doc.doc);
            Field[] fields = document.getFields("title");
            CompressionTest.assertEquals((int)1, (int)fields.length);
            CompressionTest.assertTrue((boolean)fields[0].isIndexed());
            CompressionTest.assertTrue((boolean)fields[0].isStored());
            CompressionTest.assertFalse((boolean)this.isCompressed(fields[0]));
            CompressionTest.assertEquals((String)"Hibernate in Action, third edition", (String)fields[0].stringValue());
            fields = document.getFields("abstract");
            CompressionTest.assertEquals((int)1, (int)fields.length);
            CompressionTest.assertTrue((boolean)this.isCompressed(fields[0]));
            CompressionTest.assertEquals((String)"<b>JPA2 with Hibernate</b>", (String)this.restoreValue(fields[0]));
            fields = document.getFields("text");
            CompressionTest.assertEquals((int)1, (int)fields.length);
            CompressionTest.assertTrue((boolean)this.isCompressed(fields[0]));
            CompressionTest.assertEquals((String)"This is a placeholder for the new text that you should write", (String)this.restoreValue(fields[0]));
        }
        finally {
            this.getSearchFactory().getReaderProvider().closeReader(indexReader);
        }
    }

    public void testCompressedFieldSearch() throws Exception {
        this.assertFindsN(1, "title:third");
        this.assertFindsN(1, "abstract:jpa2");
        this.assertFindsN(1, "text:write");
        this.assertFindsN(0, "text:jpa2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertFindsN(int expectedToFind, String queryString) throws ParseException {
        this.openSession().beginTransaction();
        try {
            FullTextSession fullTextSession = Search.getFullTextSession((Session)this.session);
            QueryParser queryParser = new QueryParser(CompressionTest.getTargetLuceneVersion(), "", (Analyzer)new SimpleAnalyzer(CompressionTest.getTargetLuceneVersion()));
            Query query = queryParser.parse(queryString);
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{LargeDocument.class});
            List list = fullTextQuery.list();
            Assert.assertEquals((int)expectedToFind, (int)list.size());
            if (expectedToFind == 1) {
                Assert.assertEquals((String)"Hibernate in Action, third edition", (String)((LargeDocument)list.get(0)).getTitle());
            }
        }
        finally {
            this.session.getTransaction().commit();
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProjectionOnCompressedFields() {
        this.openSession().beginTransaction();
        try {
            FullTextSession fullTextSession = Search.getFullTextSession((Session)this.session);
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{LargeDocument.class});
            List list = fullTextQuery.setProjection(new String[]{"title", "abstract", "text"}).list();
            Assert.assertEquals((int)1, (int)list.size());
            Object[] results = (Object[])list.get(0);
            Assert.assertEquals((Object)"Hibernate in Action, third edition", (Object)results[0]);
            Assert.assertEquals((Object)"JPA2 with Hibernate", (Object)results[1]);
            Assert.assertEquals((Object)"This is a placeholder for the new text that you should write", (Object)results[2]);
        }
        finally {
            this.session.getTransaction().commit();
            this.session.close();
        }
    }

    private String restoreValue(Field field) throws DataFormatException {
        if (field.isBinary()) {
            Assert.assertNull((String)"we rely on this in the Projection implementation", (Object)field.stringValue());
            return CompressionTools.decompressString((byte[])field.getBinaryValue());
        }
        return field.stringValue();
    }

    private boolean isCompressed(Field field) {
        if (!field.isBinary()) {
            return false;
        }
        try {
            CompressionTools.decompressString((byte[])field.getBinaryValue());
            return true;
        }
        catch (DataFormatException e) {
            return false;
        }
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{LargeDocument.class};
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Session s = this.openSession();
        s.getTransaction().begin();
        s.persist((Object)new LargeDocument("Hibernate in Action, third edition", "JPA2 with Hibernate", "This is a placeholder for the new text that you should write"));
        s.getTransaction().commit();
        s.close();
    }
}

