/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.graph;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.hibernate.classic.Session;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.embedded.graph.Event;
import org.hibernate.search.test.embedded.graph.ParentOfBirthEvent;
import org.hibernate.search.test.embedded.graph.Person;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursiveGraphTest
extends SearchTestCase {
    public void testCreateParentAndChild() throws Exception {
        Person[] people = new Person[2];
        Person parent = new Person();
        parent.setName("parent");
        Person child = new Person();
        child.setName("child");
        this.connectChildToParent(child, parent);
        people[0] = parent;
        people[1] = child;
        this.savePeople(people);
        RecursiveGraphTest.assertEquals((int)2, (int)this.getDocumentNbr(Person.class));
    }

    private void connectChildToParent(Person child, Person parent) {
        Event birthEvent = child.getBirthEvent();
        child.setBirthEvent(birthEvent);
        ParentOfBirthEvent parentOfBirthEvent = new ParentOfBirthEvent(parent, child.getBirthEvent());
        parent.getParentOfBirthEvents().add(parentOfBirthEvent);
    }

    public void savePeople(Person ... people) {
        for (Person person : people) {
            if (person == null) continue;
            Session s = this.getSessions().openSession();
            s.getTransaction().begin();
            s.save((Object)person);
            s.getTransaction().commit();
            s.close();
        }
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Event.class, Person.class, ParentOfBirthEvent.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDocumentNbr(Class type) throws Exception {
        IndexReader reader = IndexReader.open((Directory)this.getDirectory(type), (boolean)false);
        try {
            int n = reader.numDocs();
            return n;
        }
        finally {
            reader.close();
        }
    }
}

