/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import java.util.Calendar;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeFilter;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.filter.Driver;
import org.hibernate.search.test.filter.Soap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterTest
extends SearchTestCase {
    public void testNamedFilters() {
        this.createData();
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        s.getTransaction().begin();
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("teacher", "andre")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("teacher", "max")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("teacher", "aaron")), BooleanClause.Occur.SHOULD);
        FullTextQuery ftQuery = s.createFullTextQuery((Query)query, new Class[]{Driver.class});
        FilterTest.assertEquals((String)"No filter should happen", (int)3, (int)ftQuery.getResultSize());
        ftQuery = s.createFullTextQuery((Query)query, new Class[]{Driver.class});
        ftQuery.disableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("bestDriver");
        FilterTest.assertEquals((String)"Should filter out Gavin", (int)2, (int)ftQuery.getResultSize());
        ftQuery = s.createFullTextQuery((Query)query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("security").setParameter("login", (Object)"andre");
        FilterTest.assertEquals((String)"Should filter to limit to Emmanuel", (int)1, (int)ftQuery.getResultSize());
        ftQuery = s.createFullTextQuery((Query)query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("security").setParameter("login", (Object)"andre");
        ftQuery.disableFullTextFilter("security");
        ftQuery.disableFullTextFilter("bestDriver");
        FilterTest.assertEquals((String)"Should not filter anymore", (int)3, (int)ftQuery.getResultSize());
        s.getTransaction().commit();
        s.close();
        this.deleteData();
    }

    public void testCache() {
        this.createData();
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        s.getTransaction().begin();
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("teacher", "andre")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("teacher", "max")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("teacher", "aaron")), BooleanClause.Occur.SHOULD);
        FullTextQuery ftQuery = s.createFullTextQuery((Query)query, new Class[]{Driver.class});
        FilterTest.assertEquals((String)"No filter should happen", (int)3, (int)ftQuery.getResultSize());
        ftQuery = s.createFullTextQuery((Query)query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheresultstest");
        FilterTest.assertEquals((String)"Should filter out all", (int)0, (int)ftQuery.getResultSize());
        System.gc();
        ftQuery = s.createFullTextQuery((Query)query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheresultstest");
        try {
            ftQuery.getResultSize();
        }
        catch (IllegalStateException e) {
            FilterTest.fail((String)"Cache results does not work");
        }
        ftQuery = s.createFullTextQuery((Query)query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancetest");
        FilterTest.assertEquals((String)"Should filter out all", (int)0, (int)ftQuery.getResultSize());
        ftQuery = s.createFullTextQuery((Query)query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancetest");
        try {
            ftQuery.getResultSize();
            FilterTest.fail((String)"Cache instance does not work");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        s.getTransaction().commit();
        s.close();
        this.deleteData();
    }

    public void testStraightFilters() {
        this.createData();
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        s.getTransaction().begin();
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("teacher", "andre")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("teacher", "max")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("teacher", "aaron")), BooleanClause.Occur.SHOULD);
        FullTextQuery ftQuery = s.createFullTextQuery((Query)query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        TermRangeFilter dateFilter = new TermRangeFilter("delivery", "2001", "2005", true, true);
        ftQuery.setFilter((Filter)dateFilter);
        FilterTest.assertEquals((String)"Should select only liz", (int)1, (int)ftQuery.getResultSize());
        ftQuery = s.createFullTextQuery((Query)query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("empty");
        FilterTest.assertEquals((String)"two filters, one is empty, should not match anything", (int)0, (int)ftQuery.getResultSize());
        ftQuery = s.createFullTextQuery((Query)query, new Class[]{Driver.class});
        ftQuery.setFilter((Filter)dateFilter);
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("security").setParameter("login", (Object)"andre");
        ftQuery.disableFullTextFilter("security");
        ftQuery.disableFullTextFilter("bestDriver");
        ftQuery.setFilter(null);
        FilterTest.assertEquals((String)"Should not filter anymore", (int)3, (int)ftQuery.getResultSize());
        s.getTransaction().commit();
        s.close();
        this.deleteData();
    }

    private void deleteData() {
        Session s = this.openSession();
        s.getTransaction().begin();
        s.createQuery("delete " + Driver.class.getName() + " t").executeUpdate();
        s.getTransaction().commit();
        s.close();
    }

    private void createData() {
        Session s = this.openSession();
        s.getTransaction().begin();
        Calendar cal = Calendar.getInstance();
        cal.set(2006, 10, 11);
        Driver driver = new Driver();
        driver.setDelivery(cal.getTime());
        driver.setId(1);
        driver.setName("Emmanuel");
        driver.setScore(5);
        driver.setTeacher("andre");
        s.persist((Object)driver);
        cal.set(2007, 10, 11);
        driver = new Driver();
        driver.setDelivery(cal.getTime());
        driver.setId(2);
        driver.setName("Gavin");
        driver.setScore(3);
        driver.setTeacher("aaron");
        s.persist((Object)driver);
        cal.set(2004, 10, 11);
        driver = new Driver();
        driver.setDelivery(cal.getTime());
        driver.setId(3);
        driver.setName("Liz");
        driver.setScore(5);
        driver.setTeacher("max");
        s.persist((Object)driver);
        s.getTransaction().commit();
        s.close();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        FilterTest.setCfg(null);
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Driver.class, Soap.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.filter.cache_docidresults.size", "10");
    }
}

