/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.reader.functionality;

import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.reader.SharingBufferReaderProvider;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.reader.Detective;
import org.hibernate.search.test.reader.Suspect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterOnDirectoryTest
extends SearchTestCase {
    public void testFilteredClasses() throws Exception {
        this.createDoeFamily();
        FullTextSession fts = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fts.beginTransaction();
        TermQuery q = new TermQuery(new Term("name", "doe"));
        FilterOnDirectoryTest.assertEquals((int)2, (int)fts.createFullTextQuery((Query)q, new Class[0]).getResultSize());
        FilterOnDirectoryTest.assertEquals((int)2, (int)fts.createFullTextQuery((Query)q, new Class[]{Detective.class, Suspect.class}).getResultSize());
        FullTextQuery detectiveQuery = fts.createFullTextQuery((Query)q, new Class[]{Detective.class});
        FilterOnDirectoryTest.assertEquals((int)1, (int)detectiveQuery.getResultSize());
        FilterOnDirectoryTest.assertTrue((boolean)(detectiveQuery.list().get(0) instanceof Detective));
        FullTextQuery suspectQuery = fts.createFullTextQuery((Query)q, new Class[]{Suspect.class});
        FilterOnDirectoryTest.assertEquals((int)1, (int)suspectQuery.getResultSize());
        FilterOnDirectoryTest.assertTrue((boolean)(suspectQuery.list().get(0) instanceof Suspect));
        FilterOnDirectoryTest.assertEquals((int)2, (int)fts.createFullTextQuery((Query)q, new Class[0]).getResultSize());
        FilterOnDirectoryTest.assertEquals((int)2, (int)fts.createFullTextQuery((Query)q, new Class[]{Detective.class, Suspect.class}).getResultSize());
        tx.commit();
        fts.close();
    }

    private void createDoeFamily() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Detective detective = new Detective();
        detective.setName("John Doe");
        s.persist((Object)detective);
        Suspect suspect = new Suspect();
        suspect.setName("Jane Doe");
        s.persist((Object)suspect);
        tx.commit();
        s.close();
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.analyzer", StandardAnalyzer.class.getName());
        cfg.setProperty("hibernate.search.reader.strategy", SharingBufferReaderProvider.class.getName());
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Detective.class, Suspect.class};
    }
}

