/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.shards;

import java.io.Serializable;
import java.util.Properties;
import org.apache.lucene.document.Document;
import org.hibernate.search.FullTextFilter;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.IndexShardingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomerShardingStrategy
implements IndexShardingStrategy {
    private DirectoryProvider<?>[] providers;

    public void initialize(Properties properties, DirectoryProvider<?>[] providers) {
        this.providers = providers;
    }

    public DirectoryProvider<?>[] getDirectoryProvidersForAllShards() {
        return this.providers;
    }

    public DirectoryProvider<?> getDirectoryProviderForAddition(Class<?> entity, Serializable id, String idInString, Document document) {
        Integer customerID = Integer.parseInt(document.getField("customerID").stringValue());
        return this.providers[customerID];
    }

    public DirectoryProvider<?>[] getDirectoryProvidersForDeletion(Class<?> entity, Serializable id, String idInString) {
        return this.getDirectoryProvidersForAllShards();
    }

    public DirectoryProvider<?>[] getDirectoryProvidersForQuery(FullTextFilterImplementor[] filters) {
        FullTextFilter filter = this.getCustomerFilter(filters, "customer");
        if (filter == null) {
            return this.getDirectoryProvidersForAllShards();
        }
        return new DirectoryProvider[]{this.providers[Integer.parseInt(filter.getParameter("customerID").toString())]};
    }

    private FullTextFilter getCustomerFilter(FullTextFilterImplementor[] filters, String name) {
        for (FullTextFilterImplementor filter : filters) {
            if (!filter.getName().equals(name)) continue;
            return filter;
        }
        return null;
    }
}

