/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerConsumerQueue<T> {
    private static final int DEFAULT_BUFF_LENGHT = 1000;
    private static final Object exitToken = new Object();
    private final BlockingQueue queue;
    private final AtomicInteger producersToWaitFor;

    public ProducerConsumerQueue(int producersToWaitFor) {
        this(1000, producersToWaitFor);
    }

    public ProducerConsumerQueue(int queueLenght, int producersToWaitFor) {
        this.queue = new ArrayBlockingQueue(queueLenght);
        this.producersToWaitFor = new AtomicInteger(producersToWaitFor);
    }

    public T take() throws InterruptedException {
        Object obj = this.queue.take();
        if (obj == exitToken) {
            this.queue.put(exitToken);
            return null;
        }
        return (T)obj;
    }

    public void put(T obj) throws InterruptedException {
        this.queue.put(obj);
    }

    public void producerStopping() {
        int activeProducers = this.producersToWaitFor.decrementAndGet();
        if (activeProducers == 0) {
            try {
                this.queue.put(exitToken);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

