/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.mysql;

import java.util.Map;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.GeolatteGeometryType;
import org.hibernate.spatial.JTSGeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.mysql.MySQLGeometryTypeDescriptor;
import org.hibernate.spatial.dialect.mysql.MySQLSpatialFunctions;
import org.hibernate.type.BasicType;

public class MySQLSpatialDialect
extends MySQLDialect
implements SpatialDialect {
    public MySQLSpatialDialect() {
        this.registerColumnType(MySQLGeometryTypeDescriptor.INSTANCE.getSqlType(), "GEOMETRY");
        for (Map.Entry<String, StandardSQLFunction> entry : new MySQLSpatialFunctions()) {
            this.registerFunction(entry.getKey(), (SQLFunction)entry.getValue());
        }
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        typeContributions.contributeType((BasicType)new GeolatteGeometryType(MySQLGeometryTypeDescriptor.INSTANCE, typeContributions.getTypeDescriptorRegistryAccess()));
        typeContributions.contributeType((BasicType)new JTSGeometryType(MySQLGeometryTypeDescriptor.INSTANCE, typeContributions.getTypeDescriptorRegistryAccess()));
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        switch (spatialRelation) {
            case 4: {
                return " within(" + columnName + ",?)";
            }
            case 6: {
                return " contains(" + columnName + ", ?)";
            }
            case 3: {
                return " crosses(" + columnName + ", ?)";
            }
            case 5: {
                return " overlaps(" + columnName + ", ?)";
            }
            case 1: {
                return " disjoint(" + columnName + ", ?)";
            }
            case 7: {
                return " intersects(" + columnName + ", ?)";
            }
            case 2: {
                return " touches(" + columnName + ", ?)";
            }
            case 0: {
                return " equals(" + columnName + ", ?)";
            }
        }
        throw new IllegalArgumentException("Spatial relation is not known by this dialect");
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return "MBRIntersects(" + columnName + ", ? ) ";
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        throw new UnsupportedOperationException("Mysql has no spatial aggregate SQL functions.");
    }

    @Override
    public String getDWithinSQL(String columnName) {
        throw new UnsupportedOperationException(String.format("Mysql doesn't support the Dwithin function", new Object[0]));
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return " (srid(" + columnName + ") = ?) ";
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String emptyExpr = " IsEmpty(" + columnName + ") ";
        return isEmpty ? emptyExpr : "( NOT " + emptyExpr + ")";
    }

    @Override
    public boolean supportsFiltering() {
        return false;
    }

    @Override
    public boolean supports(SpatialFunction function) {
        switch (function) {
            case boundary: 
            case relate: 
            case distance: 
            case buffer: 
            case convexhull: 
            case difference: 
            case symdifference: 
            case intersection: 
            case geomunion: 
            case dwithin: 
            case transform: {
                return false;
            }
        }
        return true;
    }
}

