/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver;

import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.SQLServer2008Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.GeolatteGeometryType;
import org.hibernate.spatial.JTSGeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.sqlserver.SqlServer2008GeometryTypeDescriptor;
import org.hibernate.spatial.dialect.sqlserver.SqlServerMethod;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class SqlServer2008SpatialDialect
extends SQLServer2008Dialect
implements SpatialDialect {
    public static final String SHORT_NAME = "sqlserver";

    public SqlServer2008SpatialDialect() {
        this.registerColumnType(SqlServer2008GeometryTypeDescriptor.INSTANCE.getSqlType(), "GEOMETRY");
        this.registerFunction("dimension", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "?1.STDimension()"));
        this.registerFunction("geometrytype", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "?1.STGeometryType()"));
        this.registerFunction("srid", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "?1.STSrid"));
        this.registerFunction("envelope", (SQLFunction)new SqlServerMethod("STEnvelope"));
        this.registerFunction("astext", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "?1.STAsText()"));
        this.registerFunction("asbinary", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BINARY, "?1.STAsBinary()"));
        this.registerFunction("isempty", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STIsEmpty()"));
        this.registerFunction("issimple", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STIsSimple()"));
        this.registerFunction("boundary", (SQLFunction)new SqlServerMethod("STBoundary"));
        this.registerFunction("contains", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STContains(?2)"));
        this.registerFunction("crosses", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STCrosses(?2)"));
        this.registerFunction("disjoint", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STDisjoint(?2)"));
        this.registerFunction("equals", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STEquals(?2)"));
        this.registerFunction("intersects", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STIntersects(?2)"));
        this.registerFunction("overlaps", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STOverlaps(?2)"));
        this.registerFunction("touches", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STTouches(?2)"));
        this.registerFunction("within", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STWithin(?2)"));
        this.registerFunction("relate", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.BOOLEAN, "?1.STRelate(?2,?3)"));
        this.registerFunction("distance", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.DOUBLE, "?1.STDistance(?2)"));
        this.registerFunction("buffer", (SQLFunction)new SqlServerMethod("STBuffer"));
        this.registerFunction("convexhull", (SQLFunction)new SqlServerMethod("STConvexHull"));
        this.registerFunction("difference", (SQLFunction)new SqlServerMethod("STDifference"));
        this.registerFunction("intersection", (SQLFunction)new SqlServerMethod("STIntersection"));
        this.registerFunction("symdifference", (SQLFunction)new SqlServerMethod("STSymDifference"));
        this.registerFunction("geomunion", (SQLFunction)new SqlServerMethod("STUnion"));
        this.registerFunction("area", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.DOUBLE, "?1.STArea()"));
        this.registerFunction("centroid", (SQLFunction)new SqlServerMethod("STCentroid"));
        this.registerFunction("pointonsurface", (SQLFunction)new SqlServerMethod("STPointOnSurface"));
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        typeContributions.contributeType((BasicType)new GeolatteGeometryType(SqlServer2008GeometryTypeDescriptor.INSTANCE, typeContributions.getTypeDescriptorRegistryAccess()));
        typeContributions.contributeType((BasicType)new JTSGeometryType(SqlServer2008GeometryTypeDescriptor.INSTANCE, typeContributions.getTypeDescriptorRegistryAccess()));
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        String stfunction;
        switch (spatialRelation) {
            case 4: {
                stfunction = "STWithin";
                break;
            }
            case 6: {
                stfunction = "STContains";
                break;
            }
            case 3: {
                stfunction = "STCrosses";
                break;
            }
            case 5: {
                stfunction = "STOverlaps";
                break;
            }
            case 1: {
                stfunction = "STDisjoint";
                break;
            }
            case 7: {
                stfunction = "STIntersects";
                break;
            }
            case 2: {
                stfunction = "STTouches";
                break;
            }
            case 0: {
                stfunction = "STEquals";
                break;
            }
            default: {
                throw new IllegalArgumentException("Spatial relation is not known by this dialect");
            }
        }
        return columnName + "." + stfunction + "(?) = 1";
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return columnName + ".Filter(?) = 1";
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        throw new UnsupportedOperationException("No spatial aggregate SQL functions.");
    }

    @Override
    public String getDWithinSQL(String columnName) {
        throw new UnsupportedOperationException("SQL Server has no DWithin function.");
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return columnName + ".STSrid = (?)";
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String base = "(" + columnName + ".STIsEmpty() ";
        return isEmpty ? base + " = 1 )" : base + " = 0 )";
    }

    @Override
    public boolean supportsFiltering() {
        return true;
    }

    @Override
    public boolean supports(SpatialFunction function) {
        return this.getFunctions().get(function.toString()) != null;
    }
}

