/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.hana;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.Point;
import org.hibernate.spatial.dialect.hana.HANASpatialUtils;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class HANAPointTypeDescriptor
implements SqlTypeDescriptor {
    public static final HANAPointTypeDescriptor INSTANCE = new HANAPointTypeDescriptor();
    private static final long serialVersionUID = -6978798264716544804L;

    public int getSqlType() {
        return 2002;
    }

    public boolean canBeRemapped() {
        return false;
    }

    public <X> ValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Point geometry = (Point)this.getJavaDescriptor().unwrap(value, Point.class, options);
                st.setObject(index, HANASpatialUtils.toEWKB(geometry));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Point geometry = (Point)this.getJavaDescriptor().unwrap(value, Point.class, options);
                st.setObject(name, (Object)HANASpatialUtils.toEWKB(geometry));
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap(HANASpatialUtils.toGeometry(rs.getObject(name)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap(HANASpatialUtils.toGeometry(statement.getObject(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap(HANASpatialUtils.toGeometry(statement.getObject(name)), options);
            }
        };
    }
}

