/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.postgis;

import java.util.Map;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.PostgreSQL82Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.postgis.PGGeometryTypeDescriptor;
import org.hibernate.spatial.dialect.postgis.PostgisSupport;

public class PostgisPG82Dialect
extends PostgreSQL82Dialect
implements SpatialDialect {
    private transient PostgisSupport support = new PostgisSupport();

    public PostgisPG82Dialect() {
        this.registerColumnType(PGGeometryTypeDescriptor.INSTANCE_WKB_1.getSqlType(), "GEOMETRY");
        for (Map.Entry<String, SQLFunction> entry : this.support.functionsToRegister()) {
            this.registerFunction(entry.getKey(), entry.getValue());
        }
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        this.support.contributeTypes(typeContributions, serviceRegistry);
    }

    public boolean equivalentTypes(int typeCode1, int typeCode2) {
        return super.equivalentTypes(typeCode1, typeCode2) || this.support.isSpatial(typeCode1) && this.support.isSpatial(typeCode2);
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        return this.support.getSpatialRelateSQL(columnName, spatialRelation);
    }

    @Override
    public String getDWithinSQL(String columnName) {
        return this.support.getDWithinSQL(columnName);
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return this.support.getHavingSridSQL(columnName);
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        return this.support.getIsEmptySQL(columnName, isEmpty);
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return this.support.getSpatialFilterExpression(columnName);
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        return this.support.getSpatialAggregateSQL(columnName, aggregation);
    }

    @Override
    public boolean supportsFiltering() {
        return this.support.supportsFiltering();
    }

    @Override
    public boolean supports(SpatialFunction function) {
        return this.support.supports(function);
    }
}

