/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.bytecode.enhancement;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.enhance.spi.UnloadedClass;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.cfg.Environment;
import org.hibernate.testing.bytecode.enhancement.ClassEnhancementSelector;
import org.hibernate.testing.bytecode.enhancement.ClassEnhancementSelectors;
import org.hibernate.testing.bytecode.enhancement.ClassSelector;
import org.hibernate.testing.bytecode.enhancement.CustomEnhancementContext;
import org.hibernate.testing.bytecode.enhancement.EnhancementOptions;
import org.hibernate.testing.bytecode.enhancement.EnhancementSelector;
import org.hibernate.testing.bytecode.enhancement.EnhancerTestContext;
import org.hibernate.testing.bytecode.enhancement.ImplEnhancementSelector;
import org.hibernate.testing.bytecode.enhancement.ImplEnhancementSelectors;
import org.hibernate.testing.bytecode.enhancement.PackageEnhancementSelector;
import org.hibernate.testing.bytecode.enhancement.PackageEnhancementSelectors;
import org.hibernate.testing.bytecode.enhancement.PackageSelector;
import org.hibernate.testing.junit4.CustomRunner;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class BytecodeEnhancerRunner
extends Suite {
    private static final RunnerBuilder CUSTOM_RUNNER_BUILDER = new RunnerBuilder(){

        public Runner runnerForClass(Class<?> testClass) throws Throwable {
            return new CustomRunner(testClass);
        }
    };

    public BytecodeEnhancerRunner(Class<?> klass) throws ClassNotFoundException, InitializationError {
        super(CUSTOM_RUNNER_BUILDER, klass, (Class[])BytecodeEnhancerRunner.enhanceTestClass(klass));
    }

    private static Class<?>[] enhanceTestClass(Class<?> klass) throws ClassNotFoundException {
        String packageName = klass.getPackage().getName();
        ArrayList classList = new ArrayList();
        try {
            if (klass.isAnnotationPresent(EnhancementOptions.class) || klass.isAnnotationPresent(ClassEnhancementSelector.class) || klass.isAnnotationPresent(ClassEnhancementSelectors.class) || klass.isAnnotationPresent(PackageEnhancementSelector.class) || klass.isAnnotationPresent(PackageEnhancementSelectors.class) || klass.isAnnotationPresent(ImplEnhancementSelector.class) || klass.isAnnotationPresent(ImplEnhancementSelectors.class)) {
                classList.add(BytecodeEnhancerRunner.buildEnhancerClassLoader(klass).loadClass(klass.getName()));
            } else if (klass.isAnnotationPresent(CustomEnhancementContext.class)) {
                for (Class<? extends EnhancementContext> contextClass : klass.getAnnotation(CustomEnhancementContext.class).value()) {
                    EnhancementContext enhancementContextInstance = contextClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    classList.add(BytecodeEnhancerRunner.getEnhancerClassLoader(enhancementContextInstance, packageName).loadClass(klass.getName()));
                }
            } else {
                classList.add(BytecodeEnhancerRunner.getEnhancerClassLoader((EnhancementContext)new EnhancerTestContext(), packageName).loadClass(klass.getName()));
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return classList.toArray(new Class[0]);
    }

    private static ClassLoader buildEnhancerClassLoader(Class<?> klass) {
        final EnhancementOptions options = klass.getAnnotation(EnhancementOptions.class);
        EnhancerTestContext enhancerContext = options == null ? new EnhancerTestContext() : new EnhancerTestContext(){

            @Override
            public boolean doBiDirectionalAssociationManagement(UnloadedField field) {
                return options.biDirectionalAssociationManagement() && super.doBiDirectionalAssociationManagement(field);
            }

            @Override
            public boolean doDirtyCheckingInline(UnloadedClass classDescriptor) {
                return options.inlineDirtyChecking() && super.doDirtyCheckingInline(classDescriptor);
            }

            @Override
            public boolean doExtendedEnhancement(UnloadedClass classDescriptor) {
                return options.extendedEnhancement() && super.doExtendedEnhancement(classDescriptor);
            }

            @Override
            public boolean hasLazyLoadableAttributes(UnloadedClass classDescriptor) {
                return options.lazyLoading() && super.hasLazyLoadableAttributes(classDescriptor);
            }

            @Override
            public boolean isLazyLoadable(UnloadedField field) {
                return options.lazyLoading() && super.isLazyLoadable(field);
            }
        };
        ArrayList<EnhancementSelector> selectors = new ArrayList<EnhancementSelector>();
        selectors.add(new PackageSelector(klass.getPackage().getName()));
        BytecodeEnhancerRunner.applySelectors(klass, ClassEnhancementSelector.class, ClassEnhancementSelectors.class, selectorAnnotation -> selectors.add(new ClassSelector(selectorAnnotation.value().getName())));
        BytecodeEnhancerRunner.applySelectors(klass, PackageEnhancementSelector.class, PackageEnhancementSelectors.class, selectorAnnotation -> selectors.add(new PackageSelector(selectorAnnotation.value())));
        BytecodeEnhancerRunner.applySelectors(klass, ImplEnhancementSelector.class, ImplEnhancementSelectors.class, selectorAnnotation -> {
            try {
                selectors.add(selectorAnnotation.impl().newInstance());
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return BytecodeEnhancerRunner.buildEnhancerClassLoader((EnhancementContext)enhancerContext, selectors);
    }

    private static <A extends Annotation> void applySelectors(Class<?> klass, Class<A> selectorAnnotationType, Class<? extends Annotation> selectorsAnnotationType, Consumer<A> action) {
        A selectorAnnotation = klass.getAnnotation(selectorAnnotationType);
        Annotation selectorsAnnotation = klass.getAnnotation(selectorsAnnotationType);
        if (selectorAnnotation != null) {
            action.accept(selectorAnnotation);
        } else if (selectorsAnnotation != null) {
            try {
                Annotation[] selectorAnnotations;
                Method valuesMethod = selectorsAnnotationType.getDeclaredMethods()[0];
                for (Annotation groupedSelectorAnnotation : selectorAnnotations = (Annotation[])valuesMethod.invoke((Object)selectorsAnnotation, new Object[0])) {
                    action.accept(groupedSelectorAnnotation);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static ClassLoader buildEnhancerClassLoader(EnhancementContext enhancerContext, List<EnhancementSelector> selectors) {
        return new EnhancingClassLoader(Environment.getBytecodeProvider().getEnhancer(enhancerContext), selectors);
    }

    private static ClassLoader getEnhancerClassLoader(EnhancementContext context, String packageName) {
        return BytecodeEnhancerRunner.buildEnhancerClassLoader(context, Collections.singletonList(new PackageSelector(packageName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(Runner runner, RunNotifier notifier) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((ParentRunner)runner).getTestClass().getJavaClass().getClassLoader());
            super.runChild(runner, notifier);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private static class EnhancingClassLoader
    extends ClassLoader {
        private static final String debugOutputDir = System.getProperty("java.io.tmpdir");
        private final Enhancer enhancer;
        private final List<EnhancementSelector> selectors;

        public EnhancingClassLoader(Enhancer enhancer, List<EnhancementSelector> selectors) {
            this.enhancer = enhancer;
            this.selectors = selectors;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            EnhancementSelector selector;
            Iterator<EnhancementSelector> iterator = this.selectors.iterator();
            do {
                if (!iterator.hasNext()) return this.getParent().loadClass(name);
            } while (!(selector = iterator.next()).select(name));
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            try (InputStream is = this.getResourceAsStream(name.replace('.', '/') + ".class");){
                if (is == null) {
                    throw new ClassNotFoundException(name + " not found");
                }
                byte[] original = new byte[is.available()];
                Serializable serializable = null;
                try (BufferedInputStream bis = new BufferedInputStream(is);){
                    bis.read(original);
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                byte[] enhanced = this.enhancer.enhance(name, original);
                if (enhanced == null) {
                    serializable = this.defineClass(name, original, 0, original.length);
                    return serializable;
                }
                File f = new File(debugOutputDir + File.separator + name.replace(".", File.separator) + ".class");
                f.getParentFile().mkdirs();
                f.createNewFile();
                try (FileOutputStream out = new FileOutputStream(f);){
                    out.write(enhanced);
                }
                Class<?> clazz = this.defineClass(name, enhanced, 0, enhanced.length);
                return clazz;
            }
            catch (Throwable t) {
                throw new ClassNotFoundException(name + " not found", t);
            }
        }
    }
}

