/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.domain.gambit;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import org.hibernate.testing.orm.domain.gambit.SimpleEntity;

@Entity
@GenericGenerator(name="increment", strategy="increment")
public class EntityWithOneToMany {
    private Integer id;
    private String name;
    private Set<SimpleEntity> others = new HashSet<SimpleEntity>();
    private List<SimpleEntity> othersIdentifierBag = new ArrayList<SimpleEntity>();
    private Integer someInteger;

    public EntityWithOneToMany() {
    }

    public EntityWithOneToMany(Integer id, String name, Integer someInteger) {
        this.id = id;
        this.name = name;
        this.someInteger = someInteger;
    }

    @Id
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @OneToMany(fetch=FetchType.LAZY)
    public Set<SimpleEntity> getOthers() {
        return this.others;
    }

    public void setOthers(Set<SimpleEntity> others) {
        this.others = others;
    }

    public Integer getSomeInteger() {
        return this.someInteger;
    }

    public void setSomeInteger(Integer someInteger) {
        this.someInteger = someInteger;
    }

    public void addOther(SimpleEntity other) {
        this.others.add(other);
    }

    @OneToMany
    @CollectionTable(name="idbag")
    @CollectionId(column=@Column(name="BAG_ID"), generator="increment", type=@Type(type="big_integer"))
    public List<SimpleEntity> getOthersIdentifierBag() {
        return this.othersIdentifierBag;
    }

    public void setOthersIdentifierBag(List<SimpleEntity> othersIdentifierBag) {
        this.othersIdentifierBag = othersIdentifierBag;
    }
}

