/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import org.hibernate.dialect.AbstractHANADialect;
import org.hibernate.dialect.CockroachDB192Dialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQL95Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.testing.orm.junit.DialectFeatureCheck;

public abstract class DialectFeatureChecks {

    public static class SupportsHypotheticalSetFunctions
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof PostgreSQLDialect || dialect instanceof AbstractHANADialect || dialect instanceof CockroachDB192Dialect || dialect instanceof DB2Dialect || dialect instanceof OracleDialect || dialect instanceof SQLServerDialect;
        }
    }

    public static class SupportsInverseDistributionFunctions
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof AbstractHANADialect || dialect instanceof CockroachDB192Dialect || dialect instanceof DB2Dialect || dialect instanceof OracleDialect || dialect instanceof SQLServerDialect;
        }
    }

    public static class SupportsStringAggregation
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof H2Dialect || dialect instanceof HSQLDialect || dialect instanceof MySQLDialect || dialect instanceof PostgreSQLDialect || dialect instanceof AbstractHANADialect || dialect instanceof CockroachDB192Dialect || dialect instanceof DB2Dialect || dialect instanceof OracleDialect || dialect instanceof SQLServerDialect;
        }
    }

    public static class ForceLobAsLastValue
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.forceLobAsLastValue();
        }
    }

    public static class DoesRepeatableReadNotCauseReadersToBlockWritersCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !dialect.doesRepeatableReadCauseReadersToBlockWriters();
        }
    }

    public static class SupportNoWait
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsNoWait();
        }
    }

    public static class SupportsReplace
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !(dialect instanceof DerbyDialect);
        }
    }

    public static class SupportsCharCodeConversion
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !(dialect instanceof DerbyDialect);
        }
    }

    public static class SupportsUnion
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsUnionAll();
        }
    }

    public static class SupportsGroupByGroupingSets
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof DB2Dialect || dialect instanceof OracleDialect || dialect instanceof PostgreSQL95Dialect || dialect instanceof SQLServerDialect;
        }
    }

    public static class SupportsGroupByRollup
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof DB2Dialect || dialect instanceof OracleDialect || dialect instanceof PostgreSQL95Dialect || dialect instanceof SQLServerDialect || dialect instanceof MySQLDialect;
        }
    }

    public static class SupportsPadWithChar
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !(dialect instanceof DerbyDialect);
        }
    }

    public static class SupportDropConstraints
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.dropConstraints();
        }
    }

    public static class SupportPartitionBy
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsPartitionBy();
        }
    }

    public static class DoesNotSupportFollowOnLocking
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !dialect.useFollowOnLocking();
        }
    }

    public static class SupportCatalogCreation
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.canCreateCatalog();
        }
    }

    public static class SupportSchemaCreation
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.canCreateSchema();
        }
    }

    public static class DoubleQuoteQuoting
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return '\"' == dialect.openQuote() && '\"' == dialect.closeQuote();
        }
    }

    public static class SupportsSkipLocked
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsSkipLocked();
        }
    }

    public static class SupportsLockTimeouts
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsLockTimeouts();
        }
    }

    public static class SupportsLobValueChangePropogation
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsLobValueChangePropogation();
        }
    }

    public static class SupportsExistsInSelectCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsExistsInSelect();
        }
    }

    public static class DoesRepeatableReadCauseReadersToBlockWritersCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.doesRepeatableReadCauseReadersToBlockWriters();
        }
    }

    public static class DoesReadCommittedNotCauseWritersToBlockReadersCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !dialect.doesReadCommittedCauseWritersToBlockReaders();
        }
    }

    public static class DoesReadCommittedCauseWritersToBlockReadersCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.doesReadCommittedCauseWritersToBlockReaders();
        }
    }

    public static class SupportsJdbcDriverProxying
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !(dialect instanceof DB2Dialect) && !(dialect instanceof DerbyDialect);
        }
    }

    public static class SupportsRowValueConstructorSyntaxCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof AbstractHANADialect || dialect instanceof CockroachDB192Dialect || dialect instanceof MySQLDialect || dialect instanceof PostgreSQLDialect;
        }
    }

    public static class HasSelfReferentialForeignKeyBugCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.hasSelfReferentialForeignKeyBug();
        }
    }

    public static class SupportsParametersInInsertSelectCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsParametersInInsertSelect();
        }
    }

    public static class SupportLimitAndOffsetCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getLimitHandler().supportsLimit() && dialect.getLimitHandler().supportsLimitOffset();
        }
    }

    public static class SupportLimitCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getLimitHandler().supportsLimit();
        }
    }

    public static class SupportsSubqueryAsLeftHandSideInPredicate
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsSubselectAsInPredicateLHS();
        }
    }

    public static class SupportsUnboundedLobLocatorMaterializationCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsExpectedLobUsagePattern() && dialect.supportsUnboundedLobLocatorMaterialization();
        }
    }

    public static class SupportsCircularCascadeDeleteCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsCircularCascadeDeleteConstraints();
        }
    }

    public static class SupportsCascadeDeleteCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsCascadeDelete();
        }
    }

    public static class SupportsResultSetPositioningOnForwardOnlyCursorCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsResultSetPositionQueryMethodsOnForwardOnlyCursor();
        }
    }

    public static class SupportsNoColumnInsert
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsNoColumnsInsert();
        }
    }

    public static class SupportsColumnCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsColumnCheck();
        }
    }

    public static class SupportsIdentityColumns
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getIdentityColumnSupport().supportsIdentityColumns();
        }
    }

    public static class UsesInputStreamToInsertBlob
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.useInputStreamToInsertBlob();
        }
    }

    public static class SupportsNationalizedData
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsNationalizedTypes();
        }
    }

    public static class SupportsExpectedLobUsagePattern
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsExpectedLobUsagePattern();
        }
    }

    public static class SupportsSequences
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsSequences();
        }
    }
}

