/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.cfg.Environment;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.Bootstrap;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.testing.jdbc.SharedDriverManagerConnectionProviderImpl;
import org.hibernate.testing.orm.domain.DomainModelDescriptor;
import org.hibernate.testing.orm.domain.StandardDomainModel;
import org.hibernate.testing.orm.jpa.PersistenceUnitInfoImpl;
import org.hibernate.testing.orm.junit.AbstractEntityManagerFactoryScope;
import org.hibernate.testing.orm.junit.EntityManagerFactoryScope;
import org.hibernate.testing.orm.junit.JUnitHelper;
import org.hibernate.testing.orm.junit.Jpa;
import org.hibernate.testing.orm.junit.SessionFactoryScopeAware;
import org.hibernate.testing.orm.junit.Setting;
import org.hibernate.testing.orm.junit.SettingProvider;
import org.hibernate.tool.schema.Action;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.AnnotationSupport;

public class EntityManagerFactoryExtension
implements TestInstancePostProcessor,
AfterAllCallback,
TestExecutionExceptionHandler {
    private static final Logger log = Logger.getLogger(EntityManagerFactoryExtension.class);
    private static final String EMF_KEY = EntityManagerFactoryScope.class.getName();

    private static ExtensionContext.Store locateExtensionStore(Object testInstance, ExtensionContext context) {
        return JUnitHelper.locateExtensionStore(EntityManagerFactoryExtension.class, context, testInstance);
    }

    public static EntityManagerFactoryScope findEntityManagerFactoryScope(Object testInstance, ExtensionContext context) {
        int i;
        ExtensionContext.Store store = EntityManagerFactoryExtension.locateExtensionStore(testInstance, context);
        EntityManagerFactoryScope existing = (EntityManagerFactoryScope)store.get((Object)EMF_KEY);
        if (existing != null) {
            return existing;
        }
        if (!context.getElement().isPresent()) {
            throw new RuntimeException("Unable to determine how to handle given ExtensionContext : " + context.getDisplayName());
        }
        Optional emfAnnWrapper = AnnotationSupport.findAnnotation((AnnotatedElement)((AnnotatedElement)context.getElement().get()), Jpa.class);
        Jpa emfAnn = (Jpa)emfAnnWrapper.orElseThrow(() -> new RuntimeException("Could not locate @EntityManagerFactory"));
        PersistenceUnitInfoImpl pui = new PersistenceUnitInfoImpl(emfAnn.persistenceUnitName());
        pui.setTransactionType(emfAnn.transactionType());
        pui.setCacheMode(emfAnn.sharedCacheMode());
        pui.setValidationMode(emfAnn.validationMode());
        pui.setExcludeUnlistedClasses(emfAnn.excludeUnlistedClasses());
        pui.getProperties().put("hibernate.jpa.compliance.query", (Object)emfAnn.queryComplianceEnabled());
        pui.getProperties().put("hibernate.jpa.compliance.transaction", (Object)emfAnn.transactionComplianceEnabled());
        pui.getProperties().put("hibernate.jpa.compliance.closed", (Object)emfAnn.closedComplianceEnabled());
        pui.getProperties().put("hibernate.jpa.compliance.proxy", (Object)emfAnn.proxyComplianceEnabled());
        pui.getProperties().put("hibernate.jpa.compliance.caching", (Object)emfAnn.cacheComplianceEnabled());
        pui.getProperties().put("hibernate.jpa.compliance.global_id_generators", (Object)emfAnn.generatorScopeComplianceEnabled());
        Setting[] properties = emfAnn.properties();
        for (i = 0; i < properties.length; ++i) {
            Setting property = properties[i];
            pui.getProperties().setProperty(property.name(), property.value());
        }
        pui.getProperties().setProperty("hibernate.generate_statistics", Boolean.toString(emfAnn.generateStatistics()));
        if (emfAnn.exportSchema()) {
            pui.getProperties().setProperty("javax.persistence.schema-generation.database.action", Action.CREATE_DROP.getExternalHbm2ddlName());
        }
        if (emfAnn.annotatedPackageNames().length > 0) {
            pui.applyManagedClassNames(emfAnn.annotatedPackageNames());
        }
        if (emfAnn.annotatedClassNames().length > 0) {
            pui.applyManagedClassNames(emfAnn.annotatedClassNames());
        }
        if (emfAnn.annotatedClasses().length > 0) {
            for (i = 0; i < emfAnn.annotatedClasses().length; ++i) {
                pui.applyManagedClassNames(emfAnn.annotatedClasses()[i].getName());
            }
        }
        if (emfAnn.xmlMappings().length > 0) {
            pui.applyMappingFiles(emfAnn.xmlMappings());
        }
        if (emfAnn.standardModels().length > 0) {
            for (i = 0; i < emfAnn.standardModels().length; ++i) {
                StandardDomainModel standardDomainModel = emfAnn.standardModels()[i];
                for (int i1 = 0; i1 < standardDomainModel.getDescriptor().getAnnotatedClasses().length; ++i1) {
                    Class annotatedClass = standardDomainModel.getDescriptor().getAnnotatedClasses()[i1];
                    pui.applyManagedClassNames(annotatedClass.getName());
                }
            }
        }
        if (emfAnn.modelDescriptorClasses().length > 0) {
            for (i = 0; i < emfAnn.modelDescriptorClasses().length; ++i) {
                Class<? extends DomainModelDescriptor> modelDescriptorClass = emfAnn.modelDescriptorClasses()[i];
                DomainModelDescriptor domainModelDescriptor = EntityManagerFactoryExtension.instantiateDomainModelDescriptor(modelDescriptorClass);
                for (int i1 = 0; i1 < domainModelDescriptor.getAnnotatedClasses().length; ++i1) {
                    Class annotatedClass = domainModelDescriptor.getAnnotatedClasses()[i1];
                    pui.applyManagedClassNames(annotatedClass.getName());
                }
            }
        }
        HashMap<String, Object> integrationSettings = new HashMap<String, Object>();
        Environment.getProperties().forEach((key, value) -> integrationSettings.put((String)key, value));
        if (!integrationSettings.containsKey("hibernate.connection.provider_class")) {
            integrationSettings.put("hibernate.connection.provider_class", (Object)SharedDriverManagerConnectionProviderImpl.getInstance());
        }
        for (int i2 = 0; i2 < emfAnn.integrationSettings().length; ++i2) {
            Setting setting = emfAnn.integrationSettings()[i2];
            integrationSettings.put(setting.name(), setting.value());
        }
        for (SettingProvider providerAnn : emfAnn.settingProviders()) {
            Class<SettingProvider.Provider<?>> providerImpl = providerAnn.provider();
            try {
                SettingProvider.Provider<?> provider = providerImpl.getConstructor(new Class[0]).newInstance(new Object[0]);
                integrationSettings.put(providerAnn.settingName(), provider.getSetting());
            }
            catch (Exception e) {
                log.error((Object)("Error obtaining setting provider for " + providerImpl.getName()), (Throwable)e);
            }
        }
        EntityManagerFactoryScopeImpl scope = new EntityManagerFactoryScopeImpl(pui, integrationSettings);
        EntityManagerFactoryExtension.locateExtensionStore(testInstance, context).put((Object)EMF_KEY, (Object)scope);
        return scope;
    }

    private static DomainModelDescriptor instantiateDomainModelDescriptor(Class<? extends DomainModelDescriptor> modelDescriptorClass) {
        try {
            Field[] declaredFields = modelDescriptorClass.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Object value;
                Field field = declaredFields[i];
                if (!ReflectHelper.isStaticField((Field)field) || !((value = field.get(null)) instanceof DomainModelDescriptor)) continue;
                return (DomainModelDescriptor)value;
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Problem accessing DomainModelDescriptor fields : " + modelDescriptorClass.getName(), e);
        }
        try {
            return modelDescriptorClass.getConstructor(null).newInstance(null);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Problem instantiation DomainModelDescriptor : " + modelDescriptorClass.getName(), e);
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        log.tracef("#postProcessTestInstance(%s, %s)", testInstance, (Object)context.getDisplayName());
        EntityManagerFactoryExtension.findEntityManagerFactoryScope(testInstance, context);
    }

    public void afterAll(ExtensionContext context) {
        EntityManagerFactoryScopeImpl removed;
        log.tracef("#afterAll(%s)", (Object)context.getDisplayName());
        Object testInstance = context.getRequiredTestInstance();
        if (testInstance instanceof SessionFactoryScopeAware) {
            ((SessionFactoryScopeAware)testInstance).injectSessionFactoryScope(null);
        }
        if ((removed = (EntityManagerFactoryScopeImpl)EntityManagerFactoryExtension.locateExtensionStore(testInstance, context).remove((Object)EMF_KEY)) != null) {
            removed.close();
        }
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        log.tracef("#handleTestExecutionException(%s, %s)", (Object)context.getDisplayName(), (Object)throwable);
        try {
            Object testInstance = context.getRequiredTestInstance();
            ExtensionContext.Store store = EntityManagerFactoryExtension.locateExtensionStore(testInstance, context);
            EntityManagerFactoryScopeImpl scope = (EntityManagerFactoryScopeImpl)store.get((Object)EMF_KEY);
            scope.releaseEntityManagerFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw throwable;
    }

    private static class EntityManagerFactoryScopeImpl
    extends AbstractEntityManagerFactoryScope {
        private final PersistenceUnitInfo persistenceUnitInfo;
        private final Map<String, Object> integrationSettings;

        private EntityManagerFactoryScopeImpl(PersistenceUnitInfo persistenceUnitInfo, Map<String, Object> integrationSettings) {
            this.persistenceUnitInfo = persistenceUnitInfo;
            this.integrationSettings = integrationSettings;
        }

        @Override
        protected EntityManagerFactory createEntityManagerFactory() {
            EntityManagerFactoryBuilder emfBuilder = Bootstrap.getEntityManagerFactoryBuilder((PersistenceUnitDescriptor)new PersistenceUnitInfoDescriptor(this.persistenceUnitInfo), this.integrationSettings);
            return emfBuilder.build();
        }
    }
}

