/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.util.List;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.testing.orm.junit.DialectContext;
import org.hibernate.testing.orm.junit.DialectFeatureCheck;
import org.hibernate.testing.orm.junit.RequiresDialect;
import org.hibernate.testing.orm.junit.RequiresDialectFeature;
import org.hibernate.testing.orm.junit.RequiresDialectFeatureGroup;
import org.hibernate.testing.orm.junit.RequiresDialects;
import org.hibernate.testing.orm.junit.SkipForDialect;
import org.hibernate.testing.orm.junit.SkipForDialectGroup;
import org.hibernate.testing.orm.junit.TestingUtil;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public class DialectFilterExtension
implements ExecutionCondition {
    private static final Logger log = Logger.getLogger(DialectFilterExtension.class);

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Dialect dialect = this.getDialect(context);
        if (dialect == null) {
            throw new RuntimeException("#getDialect returned null");
        }
        log.debugf("Checking Dialect [%s] - context = %s", (Object)dialect, (Object)context.getDisplayName());
        List<RequiresDialect> effectiveRequiresDialects = TestingUtil.findEffectiveRepeatingAnnotation(context, RequiresDialect.class, RequiresDialects.class);
        if (!effectiveRequiresDialects.isEmpty()) {
            StringBuilder requiredDialects = new StringBuilder();
            for (RequiresDialect requiresDialect : effectiveRequiresDialects) {
                requiredDialects.append(requiresDialect.value());
                requiredDialects.append(" ");
                if (!requiresDialect.value().isInstance(dialect) || !requiresDialect.matchSubTypes() && !requiresDialect.value().equals(dialect.getClass())) continue;
                return this.evaluateSkipConditions(context, dialect, "Matched @RequiresDialect");
            }
            return ConditionEvaluationResult.disabled((String)String.format(Locale.ROOT, "Failed @RequiresDialect(dialect=%s) check - found %s]", requiredDialects, dialect.getClass().getName()));
        }
        return this.evaluateSkipConditions(context, dialect, "Passed all @SkipForDialects");
    }

    private ConditionEvaluationResult evaluateSkipConditions(ExtensionContext context, Dialect dialect, String enabledResult) {
        List<SkipForDialect> effectiveSkips = TestingUtil.findEffectiveRepeatingAnnotation(context, SkipForDialect.class, SkipForDialectGroup.class);
        for (SkipForDialect effectiveSkipForDialect : effectiveSkips) {
            if (!(effectiveSkipForDialect.matchSubTypes() ? effectiveSkipForDialect.dialectClass().isInstance(dialect) : effectiveSkipForDialect.dialectClass().equals(dialect.getClass()))) continue;
            return ConditionEvaluationResult.disabled((String)"Matched @SkipForDialect");
        }
        List<RequiresDialectFeature> effectiveRequiresDialectFeatures = TestingUtil.findEffectiveRepeatingAnnotation(context, RequiresDialectFeature.class, RequiresDialectFeatureGroup.class);
        for (RequiresDialectFeature effectiveRequiresDialectFeature : effectiveRequiresDialectFeatures) {
            try {
                DialectFeatureCheck dialectFeatureCheck = effectiveRequiresDialectFeature.feature().newInstance();
                if (dialectFeatureCheck.apply(dialect)) continue;
                return ConditionEvaluationResult.disabled((String)String.format(Locale.ROOT, "Failed @RequiresDialectFeature [%s]", effectiveRequiresDialectFeature.feature()));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Unable to instantiate DialectFeatureCheck class", e);
            }
        }
        return ConditionEvaluationResult.enabled((String)enabledResult);
    }

    private Dialect getDialect(ExtensionContext context) {
        return DialectContext.getDialect();
    }
}

