/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.lang.reflect.AnnotatedElement;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.testing.orm.domain.DomainModelDescriptor;
import org.hibernate.testing.orm.domain.StandardDomainModel;
import org.hibernate.testing.orm.junit.DomainModel;
import org.hibernate.testing.orm.junit.DomainModelProducer;
import org.hibernate.testing.orm.junit.DomainModelScope;
import org.hibernate.testing.orm.junit.DomainModelScopeAware;
import org.hibernate.testing.orm.junit.JUnitHelper;
import org.hibernate.testing.orm.junit.ServiceRegistryExtension;
import org.hibernate.testing.orm.junit.ServiceRegistryScope;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.AnnotationSupport;

public class DomainModelExtension
implements TestInstancePostProcessor,
AfterAllCallback,
TestExecutionExceptionHandler {
    private static final String MODEL_KEY = MetadataImplementor.class.getName();

    private static ExtensionContext.Store locateExtensionStore(Object testInstance, ExtensionContext context) {
        return JUnitHelper.locateExtensionStore(ServiceRegistryExtension.class, context, testInstance);
    }

    public static DomainModelScope findDomainModelScope(Object testInstance, ExtensionContext context) {
        ExtensionContext.Store store = DomainModelExtension.locateExtensionStore(testInstance, context);
        DomainModelScope existing = (DomainModelScope)store.get((Object)MODEL_KEY);
        if (existing != null) {
            return existing;
        }
        ServiceRegistryScope serviceRegistryScope = ServiceRegistryExtension.findServiceRegistryScope(testInstance, context);
        DomainModelProducer modelProducer = testInstance instanceof DomainModelProducer ? (DomainModelProducer)testInstance : serviceRegistry -> {
            void var9_28;
            if (!context.getElement().isPresent()) {
                throw new RuntimeException("Unable to determine how to handle given ExtensionContext : " + context.getDisplayName());
            }
            Optional domainModelAnnotationWrapper = AnnotationSupport.findAnnotation((AnnotatedElement)((AnnotatedElement)context.getElement().get()), DomainModel.class);
            if (!domainModelAnnotationWrapper.isPresent()) {
                throw new RuntimeException("Could not locate @DomainModel annotation : " + context.getDisplayName());
            }
            DomainModel domainModelAnnotation = (DomainModel)domainModelAnnotationWrapper.get();
            MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
            ManagedBeanRegistry managedBeanRegistry = (ManagedBeanRegistry)serviceRegistry.getService(ManagedBeanRegistry.class);
            for (String string : domainModelAnnotation.annotatedPackageNames()) {
                metadataSources.addPackage(string);
            }
            for (StandardDomainModel standardDomainModel : domainModelAnnotation.standardModels()) {
                standardDomainModel.getDescriptor().applyDomainModel(metadataSources);
            }
            for (Class<? extends DomainModelDescriptor> clazz : domainModelAnnotation.modelDescriptorClasses()) {
                try {
                    DomainModelDescriptor modelDescriptor = clazz.newInstance();
                    modelDescriptor.applyDomainModel(metadataSources);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Error instantiating DomainModelDescriptor - " + clazz.getName(), e);
                }
            }
            for (Class clazz : domainModelAnnotation.annotatedClasses()) {
                metadataSources.addAnnotatedClass(clazz);
            }
            for (String string : domainModelAnnotation.annotatedClassNames()) {
                metadataSources.addAnnotatedClassName(string);
            }
            for (String string : domainModelAnnotation.xmlMappings()) {
                metadataSources.addResource(string);
            }
            MetadataBuilderImpl metadataBuilderImpl = (MetadataBuilderImpl)metadataSources.getMetadataBuilder();
            Class<? extends TypeContributor>[] classArray = domainModelAnnotation.typeContributors();
            int n = classArray.length;
            boolean bl = false;
            while (var9_28 < n) {
                Class<? extends TypeContributor> contributorType = classArray[var9_28];
                TypeContributor contributor = (TypeContributor)managedBeanRegistry.getBean(contributorType).getBeanInstance();
                contributor.contribute((TypeContributions)metadataBuilderImpl, (ServiceRegistry)serviceRegistry);
                ++var9_28;
            }
            MetadataImplementor metadataImplementor = metadataBuilderImpl.build();
            DomainModelExtension.applyCacheSettings((Metadata)metadataImplementor, domainModelAnnotation.overrideCacheStrategy(), domainModelAnnotation.concurrencyStrategy());
            return metadataImplementor;
        };
        DomainModelScopeImpl scope = new DomainModelScopeImpl(serviceRegistryScope, modelProducer);
        if (testInstance instanceof DomainModelScopeAware) {
            ((DomainModelScopeAware)testInstance).injectTestModelScope(scope);
        }
        DomainModelExtension.locateExtensionStore(testInstance, context).put((Object)MODEL_KEY, (Object)scope);
        return scope;
    }

    protected static final void applyCacheSettings(Metadata metadata, boolean overrideCacheStrategy, String cacheConcurrencyStrategy) {
        if (!overrideCacheStrategy) {
            return;
        }
        if (cacheConcurrencyStrategy.equals("")) {
            return;
        }
        for (PersistentClass entityBinding : metadata.getEntityBindings()) {
            if (entityBinding.isInherited()) continue;
            boolean hasLob = false;
            Iterator props = entityBinding.getPropertyClosureIterator();
            while (props.hasNext()) {
                Property prop = (Property)props.next();
                if (!prop.getValue().isSimpleValue() || !DomainModelExtension.isLob((SimpleValue)prop.getValue())) continue;
                hasLob = true;
                break;
            }
            if (hasLob) continue;
            ((RootClass)entityBinding).setCacheConcurrencyStrategy(cacheConcurrencyStrategy);
            entityBinding.setCached(true);
        }
        for (Collection collectionBinding : metadata.getCollectionBindings()) {
            boolean isLob = false;
            if (collectionBinding.getElement().isSimpleValue()) {
                isLob = DomainModelExtension.isLob((SimpleValue)collectionBinding.getElement());
            }
            if (isLob) continue;
            collectionBinding.setCacheConcurrencyStrategy(cacheConcurrencyStrategy);
        }
    }

    private static boolean isLob(SimpleValue value) {
        String typeName = value.getTypeName();
        if (typeName != null) {
            String significantTypeNamePart;
            switch (significantTypeNamePart = typeName.substring(typeName.lastIndexOf(46) + 1).toLowerCase(Locale.ROOT)) {
                case "blob": 
                case "blobtype": 
                case "clob": 
                case "clobtype": 
                case "nclob": 
                case "nclobtype": {
                    return true;
                }
            }
        }
        return false;
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        DomainModelExtension.findDomainModelScope(testInstance, context);
    }

    public void afterAll(ExtensionContext context) {
        ExtensionContext.Store store = DomainModelExtension.locateExtensionStore(context.getRequiredTestInstance(), context);
        DomainModelScopeImpl scope = (DomainModelScopeImpl)store.remove((Object)MODEL_KEY);
        if (scope != null) {
            scope.close();
        }
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        ExtensionContext.Store store = DomainModelExtension.locateExtensionStore(context.getRequiredTestInstance(), context);
        DomainModelScopeImpl scope = (DomainModelScopeImpl)store.get((Object)MODEL_KEY);
        if (scope != null) {
            scope.releaseModel();
        }
        throw throwable;
    }

    protected void afterMetadataBuilt(Metadata metadata) {
    }

    public static class DomainModelScopeImpl
    implements DomainModelScope,
    ExtensionContext.Store.CloseableResource {
        private final ServiceRegistryScope serviceRegistryScope;
        private final DomainModelProducer producer;
        private MetadataImplementor model;
        private boolean active = true;

        public DomainModelScopeImpl(ServiceRegistryScope serviceRegistryScope, DomainModelProducer producer) {
            this.serviceRegistryScope = serviceRegistryScope;
            this.producer = producer;
            this.model = this.createDomainModel();
        }

        private MetadataImplementor createDomainModel() {
            this.verifyActive();
            StandardServiceRegistry registry = this.serviceRegistryScope.getRegistry();
            this.model = this.producer.produceModel(registry);
            return this.model;
        }

        @Override
        public MetadataImplementor getDomainModel() {
            this.verifyActive();
            if (this.model == null) {
                this.model = this.createDomainModel();
            }
            return this.model;
        }

        private void verifyActive() {
            if (!this.active) {
                throw new RuntimeException("DomainModelScope no longer active");
            }
        }

        public void close() {
            this.active = false;
            this.releaseModel();
        }

        public void releaseModel() {
            this.model = null;
        }
    }
}

