/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cfg.context;

import java.lang.annotation.ElementType;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.List;
import org.hibernate.validator.cfg.ConstraintDef;
import org.hibernate.validator.cfg.context.ConstructorConstraintMappingContext;
import org.hibernate.validator.cfg.context.MethodConstraintMappingContext;
import org.hibernate.validator.cfg.context.PropertyConstraintMappingContext;
import org.hibernate.validator.internal.cfg.context.CascadableConstraintMappingContextImplBase;
import org.hibernate.validator.internal.cfg.context.ConfiguredConstraint;
import org.hibernate.validator.internal.cfg.context.TypeConstraintMappingContextImpl;
import org.hibernate.validator.internal.engine.cascading.AnnotatedObject;
import org.hibernate.validator.internal.engine.cascading.ArrayElement;
import org.hibernate.validator.internal.engine.cascading.ValueExtractorManager;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.util.TypeResolutionHelper;

final class PropertyConstraintMappingContextImpl
extends CascadableConstraintMappingContextImplBase<PropertyConstraintMappingContext>
implements PropertyConstraintMappingContext {
    private final TypeConstraintMappingContextImpl<?> typeContext;
    private final Member member;

    PropertyConstraintMappingContextImpl(TypeConstraintMappingContextImpl<?> typeContext, Member member) {
        super(typeContext.getConstraintMapping());
        this.typeContext = typeContext;
        this.member = member;
    }

    @Override
    protected PropertyConstraintMappingContextImpl getThis() {
        return this;
    }

    @Override
    public PropertyConstraintMappingContext constraint(ConstraintDef<?, ?> definition) {
        if (this.member instanceof Field) {
            super.addConstraint(ConfiguredConstraint.forProperty(definition, this.member));
        } else {
            super.addConstraint(ConfiguredConstraint.forExecutable(definition, (Method)this.member));
        }
        return this;
    }

    @Override
    public PropertyConstraintMappingContext ignoreAnnotations(boolean ignoreAnnotations) {
        this.mapping.getAnnotationProcessingOptions().ignoreConstraintAnnotationsOnMember(this.member, ignoreAnnotations);
        return this;
    }

    @Override
    public PropertyConstraintMappingContext property(String property, ElementType elementType) {
        return this.typeContext.property(property, elementType);
    }

    @Override
    public ConstructorConstraintMappingContext constructor(Class<?> ... parameterTypes) {
        return this.typeContext.constructor(parameterTypes);
    }

    @Override
    public MethodConstraintMappingContext method(String name, Class<?> ... parameterTypes) {
        return this.typeContext.method(name, parameterTypes);
    }

    ConstrainedElement build(ConstraintHelper constraintHelper, TypeResolutionHelper typeResolutionHelper, ValueExtractorManager valueExtractorManager) {
        if (this.member instanceof Field) {
            return new ConstrainedField(ConfigurationSource.API, (Field)this.member, this.getConstraints(constraintHelper, typeResolutionHelper, valueExtractorManager), Collections.emptySet(), this.groupConversions, this.getCascadedTypeParameters((Field)this.member, this.isCascading));
        }
        return new ConstrainedExecutable(ConfigurationSource.API, (Executable)this.member, this.getConstraints(constraintHelper, typeResolutionHelper, valueExtractorManager), this.groupConversions, this.getCascadedTypeParameters((Executable)this.member, this.isCascading));
    }

    private List<TypeVariable<?>> getCascadedTypeParameters(Field field, boolean isCascaded) {
        if (isCascaded) {
            return Collections.singletonList(field.getType().isArray() ? ArrayElement.INSTANCE : AnnotatedObject.INSTANCE);
        }
        return Collections.emptyList();
    }

    private List<TypeVariable<?>> getCascadedTypeParameters(Executable executable, boolean isCascaded) {
        if (isCascaded) {
            boolean isArray = executable instanceof Method && ((Method)executable).getReturnType().isArray();
            return Collections.singletonList(isArray ? ArrayElement.INSTANCE : AnnotatedObject.INSTANCE);
        }
        return Collections.emptyList();
    }

    @Override
    protected ConstraintDescriptorImpl.ConstraintType getConstraintType() {
        return ConstraintDescriptorImpl.ConstraintType.GENERIC;
    }
}

