/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import javax.validation.ClockProvider;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidatorContext;
import org.hibernate.validator.internal.engine.MethodValidationConfiguration;
import org.hibernate.validator.internal.engine.ValidatorFactoryImpl;
import org.hibernate.validator.internal.engine.cascading.ValueExtractorManager;
import org.hibernate.validator.internal.util.ExecutableParameterNameProvider;

public class ValidatorContextImpl
implements HibernateValidatorContext {
    private final ValidatorFactoryImpl validatorFactory;
    private MessageInterpolator messageInterpolator;
    private TraversableResolver traversableResolver;
    private ConstraintValidatorFactory constraintValidatorFactory;
    private ExecutableParameterNameProvider parameterNameProvider;
    private ClockProvider clockProvider;
    private boolean failFast;
    private final ValueExtractorManager valueExtractorManager;
    private final MethodValidationConfiguration methodValidationConfiguration = new MethodValidationConfiguration();

    public ValidatorContextImpl(ValidatorFactoryImpl validatorFactory) {
        this.validatorFactory = validatorFactory;
        this.messageInterpolator = validatorFactory.getMessageInterpolator();
        this.traversableResolver = validatorFactory.getTraversableResolver();
        this.constraintValidatorFactory = validatorFactory.getConstraintValidatorFactory();
        this.parameterNameProvider = validatorFactory.getExecutableParameterNameProvider();
        this.clockProvider = validatorFactory.getClockProvider();
        this.failFast = validatorFactory.isFailFast();
        this.valueExtractorManager = validatorFactory.getValueExtractorManager();
    }

    @Override
    public HibernateValidatorContext messageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator == null ? this.validatorFactory.getMessageInterpolator() : messageInterpolator;
        return this;
    }

    @Override
    public HibernateValidatorContext traversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver == null ? this.validatorFactory.getTraversableResolver() : traversableResolver;
        return this;
    }

    @Override
    public HibernateValidatorContext constraintValidatorFactory(ConstraintValidatorFactory factory) {
        this.constraintValidatorFactory = factory == null ? this.validatorFactory.getConstraintValidatorFactory() : factory;
        return this;
    }

    @Override
    public HibernateValidatorContext parameterNameProvider(ParameterNameProvider parameterNameProvider) {
        this.parameterNameProvider = parameterNameProvider == null ? this.validatorFactory.getExecutableParameterNameProvider() : new ExecutableParameterNameProvider(parameterNameProvider);
        return this;
    }

    public HibernateValidatorContext clockProvider(ClockProvider clockProvider) {
        this.clockProvider = clockProvider == null ? this.validatorFactory.getClockProvider() : clockProvider;
        return this;
    }

    @Override
    public HibernateValidatorContext failFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    @Override
    public HibernateValidatorContext allowOverridingMethodAlterParameterConstraint(boolean allow) {
        this.methodValidationConfiguration.allowOverridingMethodAlterParameterConstraint(allow);
        return this;
    }

    @Override
    public HibernateValidatorContext allowMultipleCascadedValidationOnReturnValues(boolean allow) {
        this.methodValidationConfiguration.allowMultipleCascadedValidationOnReturnValues(allow);
        return this;
    }

    @Override
    public HibernateValidatorContext allowParallelMethodsDefineParameterConstraints(boolean allow) {
        this.methodValidationConfiguration.allowParallelMethodsDefineParameterConstraints(allow);
        return this;
    }

    public Validator getValidator() {
        return this.validatorFactory.createValidator(this.constraintValidatorFactory, this.messageInterpolator, this.traversableResolver, this.parameterNameProvider, this.clockProvider, this.failFast, this.valueExtractorManager, this.methodValidationConfiguration);
    }
}

