/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ClockProvider;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.validator.internal.engine.ValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.cascading.AnnotatedObject;
import org.hibernate.validator.internal.engine.cascading.ArrayElement;
import org.hibernate.validator.internal.engine.cascading.ValueExtractorDescriptor;
import org.hibernate.validator.internal.engine.cascading.ValueExtractorManager;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.engine.groups.Group;
import org.hibernate.validator.internal.engine.groups.GroupWithInheritance;
import org.hibernate.validator.internal.engine.groups.Sequence;
import org.hibernate.validator.internal.engine.groups.ValidationOrder;
import org.hibernate.validator.internal.engine.groups.ValidationOrderGenerator;
import org.hibernate.validator.internal.engine.path.NodeImpl;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.engine.resolver.CachingTraversableResolverForSingleValidation;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ExecutableMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ParameterMetaData;
import org.hibernate.validator.internal.metadata.aggregated.PropertyMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ReturnValueMetaData;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.metadata.facets.Validatable;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.location.FieldConstraintLocation;
import org.hibernate.validator.internal.metadata.location.GetterConstraintLocation;
import org.hibernate.validator.internal.metadata.location.TypeArgumentConstraintLocation;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ExecutableHelper;
import org.hibernate.validator.internal.util.ExecutableParameterNameProvider;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.TypeVariableBindings;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;

public class ValidatorImpl
implements Validator,
ExecutableValidator {
    private static final Log log = LoggerFactory.make();
    private static final Collection<Class<?>> DEFAULT_GROUPS = Collections.singletonList(Default.class);
    private final transient ValidationOrderGenerator validationOrderGenerator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final BeanMetaDataManager beanMetaDataManager;
    private final ConstraintValidatorManager constraintValidatorManager;
    private final ExecutableParameterNameProvider parameterNameProvider;
    private final ClockProvider clockProvider;
    private final boolean failFast;
    private final ValueExtractorManager valueExtractorManager;

    public ValidatorImpl(ConstraintValidatorFactory constraintValidatorFactory, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, BeanMetaDataManager beanMetaDataManager, ExecutableParameterNameProvider parameterNameProvider, ClockProvider clockProvider, ValueExtractorManager valueExtractorManager, ConstraintValidatorManager constraintValidatorManager, boolean failFast) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.messageInterpolator = messageInterpolator;
        this.traversableResolver = traversableResolver;
        this.beanMetaDataManager = beanMetaDataManager;
        this.parameterNameProvider = parameterNameProvider;
        this.clockProvider = clockProvider;
        this.valueExtractorManager = valueExtractorManager;
        this.constraintValidatorManager = constraintValidatorManager;
        this.failFast = failFast;
        this.validationOrderGenerator = new ValidationOrderGenerator();
    }

    public final <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        if (!this.beanMetaDataManager.isConstrained(object.getClass())) {
            return Collections.emptySet();
        }
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T> validationContext = this.getValidationContext().forValidate(object);
        ValueContext valueContext = ValueContext.getLocalExecutionContext(this.parameterNameProvider, object, this.beanMetaDataManager.getBeanMetaData(object.getClass()), PathImpl.createRootPath());
        return this.validateInContext(validationContext, valueContext, validationOrder);
    }

    public final <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        this.sanityCheckPropertyPath(propertyName);
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T> context = this.getValidationContext().forValidateProperty(object);
        if (!this.beanMetaDataManager.isConstrained(context.getRootBeanClass())) {
            return Collections.emptySet();
        }
        PathImpl propertyPath = PathImpl.createPathFromString(propertyName);
        ValueContext valueContext = this.getValueContextForPropertyValidation(context, propertyPath);
        if (valueContext.getCurrentBean() == null) {
            throw log.getUnableToReachPropertyToValidateException(context.getRootBean(), propertyPath);
        }
        return this.validateInContext(context, valueContext, validationOrder);
    }

    public final <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        Contracts.assertNotNull(beanType, Messages.MESSAGES.beanTypeCannotBeNull());
        if (!this.beanMetaDataManager.isConstrained(beanType)) {
            return Collections.emptySet();
        }
        this.sanityCheckPropertyPath(propertyName);
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T> context = this.getValidationContext().forValidateValue(beanType);
        return this.validateValueInContext(context, value, PathImpl.createPathFromString(propertyName), validationOrder);
    }

    public <T> Set<ConstraintViolation<T>> validateParameters(T object, Method method, Object[] parameterValues, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        Contracts.assertNotNull(method, Messages.MESSAGES.validatedMethodMustNotBeNull());
        Contracts.assertNotNull(parameterValues, Messages.MESSAGES.validatedParameterArrayMustNotBeNull());
        return this.validateParameters(object, (Executable)method, parameterValues, groups);
    }

    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(Constructor<? extends T> constructor, Object[] parameterValues, Class<?> ... groups) {
        Contracts.assertNotNull(constructor, Messages.MESSAGES.validatedConstructorMustNotBeNull());
        Contracts.assertNotNull(parameterValues, Messages.MESSAGES.validatedParameterArrayMustNotBeNull());
        return this.validateParameters(null, constructor, parameterValues, groups);
    }

    public <T> Set<ConstraintViolation<T>> validateConstructorReturnValue(Constructor<? extends T> constructor, T createdObject, Class<?> ... groups) {
        Contracts.assertNotNull(constructor, Messages.MESSAGES.validatedConstructorMustNotBeNull());
        Contracts.assertNotNull(createdObject, Messages.MESSAGES.validatedConstructorCreatedInstanceMustNotBeNull());
        return this.validateReturnValue(null, constructor, createdObject, groups);
    }

    public <T> Set<ConstraintViolation<T>> validateReturnValue(T object, Method method, Object returnValue, Class<?> ... groups) {
        Contracts.assertNotNull(object, Messages.MESSAGES.validatedObjectMustNotBeNull());
        Contracts.assertNotNull(method, Messages.MESSAGES.validatedMethodMustNotBeNull());
        return this.validateReturnValue(object, (Executable)method, returnValue, groups);
    }

    private <T> Set<ConstraintViolation<T>> validateParameters(T object, Executable executable, Object[] parameterValues, Class<?> ... groups) {
        if (parameterValues == null) {
            return Collections.emptySet();
        }
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T> context = this.getValidationContext().forValidateParameters(this.parameterNameProvider, object, executable, parameterValues);
        if (!this.beanMetaDataManager.isConstrained(context.getRootBeanClass())) {
            return Collections.emptySet();
        }
        this.validateParametersInContext(context, parameterValues, validationOrder);
        return context.getFailingConstraints();
    }

    private <T> Set<ConstraintViolation<T>> validateReturnValue(T object, Executable executable, Object returnValue, Class<?> ... groups) {
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        ValidationContext<T> context = this.getValidationContext().forValidateReturnValue(object, executable, returnValue);
        if (!this.beanMetaDataManager.isConstrained(context.getRootBeanClass())) {
            return Collections.emptySet();
        }
        this.validateReturnValueInContext(context, object, returnValue, validationOrder);
        return context.getFailingConstraints();
    }

    public final BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.beanMetaDataManager.getBeanMetaData(clazz).getBeanDescriptor();
    }

    public final <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(Validator.class)) {
            return type.cast(this);
        }
        throw log.getTypeNotSupportedForUnwrappingException(type);
    }

    public ExecutableValidator forExecutables() {
        return this;
    }

    private ValidationContext.ValidationContextBuilder getValidationContext() {
        return ValidationContext.getValidationContext(this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver(), this.clockProvider, this.failFast);
    }

    private void sanityCheckPropertyPath(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            throw log.getInvalidPropertyPathException();
        }
    }

    private ValidationOrder determineGroupValidationOrder(Class<?>[] groups) {
        Contracts.assertNotNull(groups, Messages.MESSAGES.groupMustNotBeNull());
        for (Class<?> clazz : groups) {
            if (clazz != null) continue;
            throw new IllegalArgumentException(Messages.MESSAGES.groupMustNotBeNull());
        }
        Collection<Class<?>> resultGroups = groups.length == 0 ? DEFAULT_GROUPS : Arrays.asList(groups);
        return this.validationOrderGenerator.getValidationOrder(resultGroups);
    }

    private <T, U> Set<ConstraintViolation<T>> validateInContext(ValidationContext<T> context, ValueContext<U, Object> valueContext, ValidationOrder validationOrder) {
        Group group;
        if (valueContext.getCurrentBean() == null) {
            return Collections.emptySet();
        }
        BeanMetaData<U> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(valueContext.getCurrentBean()));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            group = groupIterator.next();
            valueContext.setCurrentGroup(group.getDefiningClass());
            this.validateConstraintsForCurrentGroup(context, valueContext);
            if (!this.shouldFailFast(context)) continue;
            return context.getFailingConstraints();
        }
        groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            group = groupIterator.next();
            valueContext.setCurrentGroup(group.getDefiningClass());
            this.validateCascadedConstraints(context, valueContext);
            if (!this.shouldFailFast(context)) continue;
            return context.getFailingConstraints();
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block2: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (GroupWithInheritance groupOfGroups : sequence) {
                int numberOfViolations = context.getFailingConstraints().size();
                for (Group group2 : groupOfGroups) {
                    valueContext.setCurrentGroup(group2.getDefiningClass());
                    this.validateConstraintsForCurrentGroup(context, valueContext);
                    if (this.shouldFailFast(context)) {
                        return context.getFailingConstraints();
                    }
                    this.validateCascadedConstraints(context, valueContext);
                    if (!this.shouldFailFast(context)) continue;
                    return context.getFailingConstraints();
                }
                if (context.getFailingConstraints().size() <= numberOfViolations) continue;
                continue block2;
            }
        }
        return context.getFailingConstraints();
    }

    private void validateConstraintsForCurrentGroup(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext) {
        if (!valueContext.validatingDefault()) {
            this.validateConstraintsForNonDefaultGroup(validationContext, valueContext);
        } else {
            this.validateConstraintsForDefaultGroup(validationContext, valueContext);
        }
    }

    private <U> void validateConstraintsForDefaultGroup(ValidationContext<?> validationContext, ValueContext<U, Object> valueContext) {
        BeanMetaData<U> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        HashMap<Class<?>, Class<?>> validatedInterfaces = CollectionHelper.newHashMap();
        for (Class<U> clazz : beanMetaData.getClassHierarchy()) {
            BeanMetaData<U> hostingBeanMetaData = this.beanMetaDataManager.getBeanMetaData(clazz);
            boolean defaultGroupSequenceIsRedefined = hostingBeanMetaData.defaultGroupSequenceIsRedefined();
            if (defaultGroupSequenceIsRedefined) {
                Iterator<Sequence> defaultGroupSequence = hostingBeanMetaData.getDefaultValidationSequence(valueContext.getCurrentBean());
                Set<MetaConstraint<?>> metaConstraints = hostingBeanMetaData.getMetaConstraints();
                block1: while (defaultGroupSequence.hasNext()) {
                    for (GroupWithInheritance groupOfGroups : defaultGroupSequence.next()) {
                        boolean validationSuccessful = true;
                        for (Group defaultSequenceMember : groupOfGroups) {
                            validationSuccessful = this.validateConstraintsForSingleDefaultGroupElement(validationContext, valueContext, validatedInterfaces, clazz, metaConstraints, defaultSequenceMember);
                        }
                        if (validationSuccessful) continue;
                        continue block1;
                    }
                }
            } else {
                Set<MetaConstraint<?>> metaConstraints = hostingBeanMetaData.getDirectMetaConstraints();
                this.validateConstraintsForSingleDefaultGroupElement(validationContext, valueContext, validatedInterfaces, clazz, metaConstraints, Group.DEFAULT_GROUP);
            }
            validationContext.markCurrentBeanAsProcessed(valueContext);
            if (!defaultGroupSequenceIsRedefined) continue;
            break;
        }
    }

    private <U> boolean validateConstraintsForSingleDefaultGroupElement(ValidationContext<?> validationContext, ValueContext<U, Object> valueContext, Map<Class<?>, Class<?>> validatedInterfaces, Class<? super U> clazz, Set<MetaConstraint<?>> metaConstraints, Group defaultSequenceMember) {
        boolean validationSuccessful = true;
        valueContext.setCurrentGroup(defaultSequenceMember.getDefiningClass());
        for (MetaConstraint<?> metaConstraint : metaConstraints) {
            Class<?> declaringClass = metaConstraint.getLocation().getDeclaringClass();
            if (declaringClass.isInterface()) {
                Class<?> validatedForClass = validatedInterfaces.get(declaringClass);
                if (validatedForClass != null && !validatedForClass.equals(clazz)) continue;
                validatedInterfaces.put(declaringClass, clazz);
            }
            boolean tmp = this.validateMetaConstraint(validationContext, valueContext, valueContext.getCurrentBean(), metaConstraint);
            if (this.shouldFailFast(validationContext)) {
                return false;
            }
            validationSuccessful = validationSuccessful && tmp;
        }
        return validationSuccessful;
    }

    private void validateConstraintsForNonDefaultGroup(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext) {
        BeanMetaData<?> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        this.validateMetaConstraints(validationContext, valueContext, valueContext.getCurrentBean(), beanMetaData.getMetaConstraints());
        validationContext.markCurrentBeanAsProcessed(valueContext);
    }

    private void validateMetaConstraints(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext, Object parent, Iterable<MetaConstraint<?>> constraints) {
        for (MetaConstraint<?> metaConstraint : constraints) {
            this.validateMetaConstraint(validationContext, valueContext, parent, metaConstraint);
            if (!this.shouldFailFast(validationContext)) continue;
            break;
        }
    }

    private boolean validateMetaConstraint(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext, Object parent, MetaConstraint<?> metaConstraint) {
        PathImpl currentPath = valueContext.getPropertyPath();
        valueContext.appendNode(metaConstraint.getLocation());
        boolean success = true;
        if (this.isValidationRequired(validationContext, valueContext, metaConstraint)) {
            Object valueToValidate = null;
            if (parent != null) {
                valueToValidate = valueContext.getValue(parent, metaConstraint.getLocation());
                valueContext.setCurrentValidatedValue(valueToValidate);
            } else {
                valueToValidate = valueContext.getCurrentValidatedValue();
            }
            if (metaConstraint.getValueExtractorDescriptor() != null) {
                TypeParameterValueReceiver receiver = new TypeParameterValueReceiver(validationContext, valueContext, metaConstraint);
                metaConstraint.getValueExtractorDescriptor().getValueExtractor().extractValues(valueToValidate, (ValueExtractor.ValueReceiver)receiver);
                success = receiver.isSuccess();
            } else {
                success = metaConstraint.validateConstraint(validationContext, valueContext);
            }
            validationContext.markConstraintProcessed(valueContext.getCurrentBean(), valueContext.getPropertyPath(), metaConstraint);
        }
        valueContext.setPropertyPath(currentPath);
        return success;
    }

    private void validateCascadedConstraints(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext) {
        Validatable validatable = valueContext.getCurrentValidatable();
        PathImpl originalPath = valueContext.getPropertyPath();
        Class<?> originalGroup = valueContext.getCurrentGroup();
        for (Cascadable cascadable : validatable.getCascadables()) {
            Object value;
            valueContext.appendNode(cascadable);
            Class<?> group = cascadable.convertGroup(originalGroup);
            valueContext.setCurrentGroup(group);
            ElementType elementType = cascadable.getElementType();
            if (this.isCascadeRequired(validationContext, valueContext.getCurrentBean(), valueContext.getPropertyPath(), elementType) && (value = this.getCascadableValue(validationContext, valueContext.getCurrentBean(), cascadable)) != null) {
                ValidationOrder validationOrder = this.validationOrderGenerator.getValidationOrder(group, group != originalGroup);
                this.validateCascadedValues(value, validationContext, valueContext, cascadable, validationOrder);
            }
            valueContext.setPropertyPath(originalPath);
            valueContext.setCurrentGroup(originalGroup);
        }
    }

    private void validateCascadedValues(Object value, ValidationContext<?> context, ValueContext<?, ?> valueContext, Cascadable cascadable, ValidationOrder validationOrder) {
        for (TypeVariable<?> cascadingTypeParameter : cascadable.getCascadingTypeParameters()) {
            List<TypeVariable<?>> cascadingTypeParametersOfValueType = this.getCorrespondingTypeParametersInSubType(value.getClass(), TypeHelper.getErasedReferenceType(cascadable.getCascadableType()), cascadingTypeParameter);
            for (TypeVariable<?> cascadingTypeParameterOfValueType : cascadingTypeParametersOfValueType) {
                ValueExtractorDescriptor extractor = this.valueExtractorManager.getValueExtractor(value.getClass(), cascadingTypeParameterOfValueType);
                if (extractor == null) continue;
                CascadingValueReceiver receiver = new CascadingValueReceiver(context, valueContext, validationOrder);
                extractor.getValueExtractor().extractValues(value, (ValueExtractor.ValueReceiver)receiver);
            }
        }
    }

    private List<TypeVariable<?>> getCorrespondingTypeParametersInSubType(Class<?> subType, Class<?> superType, TypeVariable<?> typeParameterOfSuperType) {
        if (typeParameterOfSuperType == AnnotatedObject.INSTANCE) {
            return Collections.singletonList(AnnotatedObject.INSTANCE);
        }
        if (typeParameterOfSuperType == ArrayElement.INSTANCE) {
            return Collections.singletonList(ArrayElement.INSTANCE);
        }
        ArrayList correspondingTypeParameters = new ArrayList();
        Map<Class<?>, Map<TypeVariable<?>, TypeVariable<?>>> allBindings = TypeVariableBindings.getTypeVariableBindings(subType);
        Map<TypeVariable<?>, TypeVariable<?>> bindingsOfSuperType = allBindings.get(superType);
        if (bindingsOfSuperType != null) {
            for (Map.Entry<TypeVariable<?>, TypeVariable<?>> binding : bindingsOfSuperType.entrySet()) {
                if (typeParameterOfSuperType != binding.getValue()) continue;
                correspondingTypeParameters.add(binding.getKey());
            }
        }
        return correspondingTypeParameters;
    }

    private ValueContext<?, Object> buildNewLocalExecutionContext(ValueContext<?, ?> valueContext, Object value) {
        ValueContext<Object, Object> newValueContext;
        if (value != null) {
            newValueContext = ValueContext.getLocalExecutionContext(this.parameterNameProvider, value, this.beanMetaDataManager.getBeanMetaData(value.getClass()), valueContext.getPropertyPath());
            newValueContext.setCurrentValidatedValue(value);
        } else {
            newValueContext = ValueContext.getLocalExecutionContext(this.parameterNameProvider, valueContext.getCurrentBeanType(), this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType()), valueContext.getPropertyPath());
        }
        return newValueContext;
    }

    private <T> Set<ConstraintViolation<T>> validateValueInContext(ValidationContext<T> context, Object value, PathImpl propertyPath, ValidationOrder validationOrder) {
        ValueContext<T, Object> valueContext = this.getValueContextForValueValidation(context, propertyPath);
        valueContext.setCurrentValidatedValue(value);
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(valueContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(null));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group = groupIterator.next();
            valueContext.setCurrentGroup(group.getDefiningClass());
            this.validateConstraintsForCurrentGroup(context, valueContext);
            if (!this.shouldFailFast(context)) continue;
            return context.getFailingConstraints();
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (GroupWithInheritance groupOfGroups : sequence) {
                int numberOfConstraintViolationsBefore = context.getFailingConstraints().size();
                for (Group group : groupOfGroups) {
                    valueContext.setCurrentGroup(group.getDefiningClass());
                    this.validateConstraintsForCurrentGroup(context, valueContext);
                    if (!this.shouldFailFast(context)) continue;
                    return context.getFailingConstraints();
                }
                if (context.getFailingConstraints().size() <= numberOfConstraintViolationsBefore) continue;
                continue block1;
            }
        }
        return context.getFailingConstraints();
    }

    private <T> void validateParametersInContext(ValidationContext<T> validationContext, Object[] parameterValues, ValidationOrder validationOrder) {
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(validationContext.getRootBeanClass());
        ExecutableMetaData executableMetaData = beanMetaData.getMetaDataFor(validationContext.getExecutable());
        if (executableMetaData == null) {
            throw log.getMethodOrConstructorNotDefinedByValidatedTypeException(beanMetaData.getBeanClass(), validationContext.getExecutable());
        }
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(validationContext.getRootBean()));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            this.validateParametersForGroup(validationContext, parameterValues, groupIterator.next());
            if (!this.shouldFailFast(validationContext)) continue;
            return;
        }
        ValueContext cascadingValueContext = ValueContext.getLocalExecutionContext(this.parameterNameProvider, parameterValues, (Validatable)executableMetaData.getValidatableParametersMetaData(), PathImpl.createPathForExecutable(executableMetaData));
        groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group = groupIterator.next();
            cascadingValueContext.setCurrentGroup(group.getDefiningClass());
            this.validateCascadedConstraints(validationContext, cascadingValueContext);
            if (!this.shouldFailFast(validationContext)) continue;
            return;
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block2: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (GroupWithInheritance groupOfGroups : sequence) {
                int numberOfViolations = validationContext.getFailingConstraints().size();
                for (Group group : groupOfGroups) {
                    this.validateParametersForGroup(validationContext, parameterValues, group);
                    if (this.shouldFailFast(validationContext)) {
                        return;
                    }
                    cascadingValueContext.setCurrentGroup(group.getDefiningClass());
                    this.validateCascadedConstraints(validationContext, cascadingValueContext);
                    if (!this.shouldFailFast(validationContext)) continue;
                    return;
                }
                if (validationContext.getFailingConstraints().size() <= numberOfViolations) continue;
                continue block2;
            }
        }
    }

    private <T> void validateParametersForGroup(ValidationContext<T> validationContext, Object[] parameterValues, Group group) {
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(validationContext.getRootBeanClass());
        ExecutableMetaData executableMetaData = beanMetaData.getMetaDataFor(validationContext.getExecutable());
        if (parameterValues.length != executableMetaData.getParameterTypes().length) {
            throw log.getInvalidParameterCountForExecutableException(ExecutableHelper.getExecutableAsString(executableMetaData.getType().toString() + "#" + executableMetaData.getName(), executableMetaData.getParameterTypes()), parameterValues.length, executableMetaData.getParameterTypes().length);
        }
        if (group.isDefaultGroup()) {
            Iterator<Sequence> defaultGroupSequence = beanMetaData.getDefaultValidationSequence(validationContext.getRootBean());
            while (defaultGroupSequence.hasNext()) {
                Sequence sequence = defaultGroupSequence.next();
                int numberOfViolations = validationContext.getFailingConstraints().size();
                for (GroupWithInheritance expandedGroup : sequence) {
                    for (Group defaultGroupSequenceElement : expandedGroup) {
                        this.validateParametersForSingleGroup(validationContext, parameterValues, executableMetaData, defaultGroupSequenceElement.getDefiningClass());
                        if (!this.shouldFailFast(validationContext)) continue;
                        return;
                    }
                    if (validationContext.getFailingConstraints().size() <= numberOfViolations) continue;
                    return;
                }
            }
        } else {
            this.validateParametersForSingleGroup(validationContext, parameterValues, executableMetaData, group.getDefiningClass());
        }
    }

    private <T> void validateParametersForSingleGroup(ValidationContext<T> validationContext, Object[] parameterValues, ExecutableMetaData executableMetaData, Class<?> currentValidatedGroup) {
        ValueContext<T, Object> valueContext;
        if (!executableMetaData.getCrossParameterConstraints().isEmpty()) {
            valueContext = this.getExecutableValueContext(validationContext.getRootBean(), executableMetaData, executableMetaData.getValidatableParametersMetaData(), currentValidatedGroup);
            this.validateMetaConstraints(validationContext, valueContext, parameterValues, executableMetaData.getCrossParameterConstraints());
            if (this.shouldFailFast(validationContext)) {
                return;
            }
        }
        valueContext = this.getExecutableValueContext(validationContext.getRootBean(), executableMetaData, executableMetaData.getValidatableParametersMetaData(), currentValidatedGroup);
        for (int i = 0; i < parameterValues.length; ++i) {
            ParameterMetaData parameterMetaData = executableMetaData.getParameterMetaData(i);
            Object value = parameterValues[i];
            if (value != null) {
                Class<?> valueType = value.getClass();
                if (parameterMetaData.getType() instanceof Class && ((Class)parameterMetaData.getType()).isPrimitive()) {
                    valueType = ReflectionHelper.unBoxedType(valueType);
                }
                if (!TypeHelper.isAssignable(TypeHelper.getErasedType(parameterMetaData.getType()), valueType)) {
                    throw log.getParameterTypesDoNotMatchException(valueType, parameterMetaData.getType(), i, validationContext.getExecutable());
                }
            }
            this.validateMetaConstraints(validationContext, valueContext, parameterValues, parameterMetaData);
            if (!this.shouldFailFast(validationContext)) continue;
            return;
        }
    }

    private <T> ValueContext<T, Object> getExecutableValueContext(T object, ExecutableMetaData executableMetaData, Validatable validatable, Class<?> group) {
        ValueContext valueContext = object != null ? ValueContext.getLocalExecutionContext(this.parameterNameProvider, object, validatable, PathImpl.createPathForExecutable(executableMetaData)) : ValueContext.getLocalExecutionContext(this.parameterNameProvider, (Class)null, validatable, PathImpl.createPathForExecutable(executableMetaData));
        valueContext.setCurrentGroup(group);
        return valueContext;
    }

    private <V, T> void validateReturnValueInContext(ValidationContext<T> context, T bean, V value, ValidationOrder validationOrder) {
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(context.getRootBeanClass());
        ExecutableMetaData executableMetaData = beanMetaData.getMetaDataFor(context.getExecutable());
        if (executableMetaData == null) {
            return;
        }
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            validationOrder.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(bean));
        }
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            this.validateReturnValueForGroup(context, bean, value, groupIterator.next());
            if (!this.shouldFailFast(context)) continue;
            return;
        }
        ValueContext cascadingValueContext = null;
        if (value != null) {
            cascadingValueContext = ValueContext.getLocalExecutionContext(this.parameterNameProvider, value, (Validatable)executableMetaData.getReturnValueMetaData(), PathImpl.createPathForExecutable(executableMetaData));
            groupIterator = validationOrder.getGroupIterator();
            while (groupIterator.hasNext()) {
                Group group = groupIterator.next();
                cascadingValueContext.setCurrentGroup(group.getDefiningClass());
                this.validateCascadedConstraints(context, cascadingValueContext);
                if (!this.shouldFailFast(context)) continue;
                return;
            }
        }
        Iterator<Sequence> sequenceIterator = validationOrder.getSequenceIterator();
        block2: while (sequenceIterator.hasNext()) {
            Sequence sequence = sequenceIterator.next();
            for (GroupWithInheritance groupOfGroups : sequence) {
                int numberOfFailingConstraintsBeforeGroup = context.getFailingConstraints().size();
                for (Group group : groupOfGroups) {
                    this.validateReturnValueForGroup(context, bean, value, group);
                    if (this.shouldFailFast(context)) {
                        return;
                    }
                    if (value == null) continue;
                    cascadingValueContext.setCurrentGroup(group.getDefiningClass());
                    this.validateCascadedConstraints(context, cascadingValueContext);
                    if (!this.shouldFailFast(context)) continue;
                    return;
                }
                if (context.getFailingConstraints().size() <= numberOfFailingConstraintsBeforeGroup) continue;
                continue block2;
            }
        }
    }

    private <T> void validateReturnValueForGroup(ValidationContext<T> validationContext, T bean, Object value, Group group) {
        BeanMetaData<T> beanMetaData = this.beanMetaDataManager.getBeanMetaData(validationContext.getRootBeanClass());
        ExecutableMetaData executableMetaData = beanMetaData.getMetaDataFor(validationContext.getExecutable());
        if (executableMetaData == null) {
            return;
        }
        if (group.isDefaultGroup()) {
            Iterator<Sequence> defaultGroupSequence = beanMetaData.getDefaultValidationSequence(bean);
            while (defaultGroupSequence.hasNext()) {
                Sequence sequence = defaultGroupSequence.next();
                int numberOfViolations = validationContext.getFailingConstraints().size();
                for (GroupWithInheritance expandedGroup : sequence) {
                    for (Group defaultGroupSequenceElement : expandedGroup) {
                        this.validateReturnValueForSingleGroup(validationContext, executableMetaData, bean, value, defaultGroupSequenceElement.getDefiningClass());
                        if (!this.shouldFailFast(validationContext)) continue;
                        return;
                    }
                    if (validationContext.getFailingConstraints().size() <= numberOfViolations) continue;
                    return;
                }
            }
        } else {
            this.validateReturnValueForSingleGroup(validationContext, executableMetaData, bean, value, group.getDefiningClass());
        }
    }

    private <T> void validateReturnValueForSingleGroup(ValidationContext<T> validationContext, ExecutableMetaData executableMetaData, T bean, Object value, Class<?> oneGroup) {
        ValueContext<Object, Object> valueContext = this.getExecutableValueContext(executableMetaData.getKind() == ElementKind.CONSTRUCTOR ? value : bean, executableMetaData, executableMetaData.getReturnValueMetaData(), oneGroup);
        ReturnValueMetaData returnValueMetaData = executableMetaData.getReturnValueMetaData();
        this.validateMetaConstraints(validationContext, valueContext, value, returnValueMetaData);
    }

    private <V> ValueContext<?, V> getValueContextForPropertyValidation(ValidationContext<?> validationContext, PathImpl propertyPath) {
        Class<?> clazz = validationContext.getRootBeanClass();
        BeanMetaData<?> beanMetaData = null;
        Object value = validationContext.getRootBean();
        AbstractConstraintMetaData propertyMetaData = null;
        Iterator<Path.Node> propertyPathIter = propertyPath.iterator();
        while (propertyPathIter.hasNext()) {
            NodeImpl propertyPathNode = (NodeImpl)propertyPathIter.next();
            beanMetaData = this.beanMetaDataManager.getBeanMetaData(clazz);
            propertyMetaData = this.getBeanPropertyMetaData(beanMetaData, (Path.Node)propertyPathNode);
            if (!propertyPathIter.hasNext()) continue;
            if (!propertyMetaData.isCascading()) {
                throw log.getInvalidPropertyPathException(validationContext.getRootBeanClass(), propertyPath.asString());
            }
            if ((value = this.getCascadableValue(validationContext, value, ((PropertyMetaData)propertyMetaData).getCascadables().iterator().next())) == null) {
                throw log.getUnableToReachPropertyToValidateException(validationContext.getRootBean(), propertyPath);
            }
            clazz = value.getClass();
            if (!propertyPathNode.isIterable()) continue;
            propertyPathNode = (NodeImpl)propertyPathIter.next();
            if (propertyPathNode.getIndex() != null) {
                value = ReflectionHelper.getIndexedValue(value, propertyPathNode.getIndex());
            } else if (propertyPathNode.getKey() != null) {
                value = ReflectionHelper.getMappedValue(value, propertyPathNode.getKey());
            } else {
                throw log.getPropertyPathMustProvideIndexOrMapKeyException();
            }
            if (value == null) {
                throw log.getUnableToReachPropertyToValidateException(validationContext.getRootBean(), propertyPath);
            }
            clazz = value.getClass();
            beanMetaData = this.beanMetaDataManager.getBeanMetaData(clazz);
            propertyMetaData = this.getBeanPropertyMetaData(beanMetaData, (Path.Node)propertyPathNode);
        }
        if (propertyMetaData == null) {
            throw log.getInvalidPropertyPathException(clazz, propertyPath.asString());
        }
        validationContext.setValidatedProperty(propertyMetaData.getName());
        propertyPath.removeLeafNode();
        return ValueContext.getLocalExecutionContext(this.parameterNameProvider, value, beanMetaData, propertyPath);
    }

    private <V> ValueContext<?, V> getValueContextForValueValidation(ValidationContext<?> validationContext, PathImpl propertyPath) {
        Class<?> clazz = validationContext.getRootBeanClass();
        BeanMetaData<?> beanMetaData = null;
        AbstractConstraintMetaData propertyMetaData = null;
        Iterator<Path.Node> propertyPathIter = propertyPath.iterator();
        while (propertyPathIter.hasNext()) {
            NodeImpl propertyPathNode = (NodeImpl)propertyPathIter.next();
            beanMetaData = this.beanMetaDataManager.getBeanMetaData(clazz);
            propertyMetaData = this.getBeanPropertyMetaData(beanMetaData, (Path.Node)propertyPathNode);
            if (!propertyPathIter.hasNext()) continue;
            if (propertyPathNode.isIterable()) {
                propertyPathNode = (NodeImpl)propertyPathIter.next();
                clazz = ReflectionHelper.getClassFromType(ReflectionHelper.getCollectionElementType(propertyMetaData.getType()));
                beanMetaData = this.beanMetaDataManager.getBeanMetaData(clazz);
                propertyMetaData = this.getBeanPropertyMetaData(beanMetaData, (Path.Node)propertyPathNode);
                continue;
            }
            clazz = ReflectionHelper.getClassFromType(propertyMetaData.getType());
        }
        if (propertyMetaData == null) {
            throw log.getInvalidPropertyPathException(clazz, propertyPath.asString());
        }
        validationContext.setValidatedProperty(propertyMetaData.getName());
        propertyPath.removeLeafNode();
        return ValueContext.getLocalExecutionContext(this.parameterNameProvider, clazz, beanMetaData, propertyPath);
    }

    private TraversableResolver getCachingTraversableResolver() {
        return new CachingTraversableResolverForSingleValidation(this.traversableResolver);
    }

    private boolean isValidationRequired(ValidationContext<?> validationContext, ValueContext<?, ?> valueContext, MetaConstraint<?> metaConstraint) {
        String propertyName;
        if (validationContext.getValidatedProperty() != null && (propertyName = this.getPropertyName(metaConstraint.getLocation())) != null && !propertyName.equals(validationContext.getValidatedProperty())) {
            return false;
        }
        if (validationContext.hasMetaConstraintBeenProcessed(valueContext.getCurrentBean(), valueContext.getPropertyPath(), metaConstraint)) {
            return false;
        }
        if (!metaConstraint.getGroupList().contains(valueContext.getCurrentGroup())) {
            return false;
        }
        return this.isReachable(validationContext, valueContext.getCurrentBean(), valueContext.getPropertyPath(), metaConstraint.getElementType());
    }

    private boolean isReachable(ValidationContext<?> validationContext, Object traversableObject, PathImpl path, ElementType type) {
        if (this.needToCallTraversableResolver(path, type)) {
            return true;
        }
        PathImpl pathToObject = path.getPathWithoutLeafNode();
        try {
            return validationContext.getTraversableResolver().isReachable(traversableObject, (Path.Node)path.getLeafNode(), validationContext.getRootBeanClass(), (Path)pathToObject, type);
        }
        catch (RuntimeException e) {
            throw log.getErrorDuringCallOfTraversableResolverIsReachableException(e);
        }
    }

    private boolean needToCallTraversableResolver(PathImpl path, ElementType type) {
        return this.isClassLevelConstraint(type) || this.isCrossParameterValidation(path) || this.isParameterValidation(path) || this.isReturnValueValidation(path);
    }

    private boolean isCascadeRequired(ValidationContext<?> validationContext, Object traversableObject, PathImpl path, ElementType type) {
        if (this.needToCallTraversableResolver(path, type)) {
            return true;
        }
        boolean isReachable = this.isReachable(validationContext, traversableObject, path, type);
        if (!isReachable) {
            return false;
        }
        PathImpl pathToObject = path.getPathWithoutLeafNode();
        try {
            return validationContext.getTraversableResolver().isCascadable(traversableObject, (Path.Node)path.getLeafNode(), validationContext.getRootBeanClass(), (Path)pathToObject, type);
        }
        catch (RuntimeException e) {
            throw log.getErrorDuringCallOfTraversableResolverIsCascadableException(e);
        }
    }

    private boolean isClassLevelConstraint(ElementType type) {
        return ElementType.TYPE.equals((Object)type);
    }

    private boolean isCrossParameterValidation(PathImpl path) {
        return path.getLeafNode().getKind() == ElementKind.CROSS_PARAMETER;
    }

    private boolean isParameterValidation(PathImpl path) {
        return path.getLeafNode().getKind() == ElementKind.PARAMETER;
    }

    private boolean isReturnValueValidation(PathImpl path) {
        return path.getLeafNode().getKind() == ElementKind.RETURN_VALUE;
    }

    private boolean shouldFailFast(ValidationContext<?> context) {
        return context.isFailFastModeEnabled() && !context.getFailingConstraints().isEmpty();
    }

    private PropertyMetaData getBeanPropertyMetaData(BeanMetaData<?> beanMetaData, Path.Node propertyNode) {
        if (!ElementKind.PROPERTY.equals((Object)propertyNode.getKind())) {
            throw log.getInvalidPropertyPathException(beanMetaData.getBeanClass(), propertyNode.getName());
        }
        PropertyMetaData propertyMetaData = beanMetaData.getMetaDataFor(propertyNode.getName());
        if (propertyMetaData == null) {
            throw log.getInvalidPropertyPathException(beanMetaData.getBeanClass(), propertyNode.getName());
        }
        return propertyMetaData;
    }

    private Object getCascadableValue(ValidationContext<?> validationContext, Object object, Cascadable cascadable) {
        return cascadable.getValue(object);
    }

    private String getPropertyName(ConstraintLocation location) {
        if (location instanceof TypeArgumentConstraintLocation) {
            location = ((TypeArgumentConstraintLocation)location).getDelegate();
        }
        if (location instanceof FieldConstraintLocation) {
            return ((FieldConstraintLocation)location).getPropertyName();
        }
        if (location instanceof GetterConstraintLocation) {
            return ((GetterConstraintLocation)location).getPropertyName();
        }
        return null;
    }

    private class CascadingValueReceiver
    implements ValueExtractor.ValueReceiver {
        private final ValidationContext<?> context;
        private final ValueContext<?, ?> valueContext;
        private final ValidationOrder validationOrder;

        public CascadingValueReceiver(ValidationContext<?> context, ValueContext<?, ?> valueContext, ValidationOrder validationOrder) {
            this.context = context;
            this.valueContext = valueContext;
            this.validationOrder = validationOrder;
        }

        public void value(String nodeName, Object value) {
            this.doValidate(value, nodeName);
        }

        public void iterableValue(String nodeName, Object value) {
            this.valueContext.markCurrentPropertyAsIterable();
            this.doValidate(value, nodeName);
        }

        public void indexedValue(String nodeName, int index, Object value) {
            this.valueContext.markCurrentPropertyAsIterable();
            this.valueContext.setIndex(index);
            this.doValidate(value, nodeName);
        }

        public void keyedValue(String nodeName, Object key, Object value) {
            this.valueContext.markCurrentPropertyAsIterable();
            this.valueContext.setKey(key);
            this.doValidate(value, nodeName);
        }

        private void doValidate(Object value, String nodeName) {
            if (this.context.isBeanAlreadyValidated(value, this.valueContext.getCurrentGroup(), this.valueContext.getPropertyPath()) || ValidatorImpl.this.shouldFailFast(this.context)) {
                return;
            }
            ValueContext cascadedValueContext = ValidatorImpl.this.buildNewLocalExecutionContext(this.valueContext, value);
            ValidatorImpl.this.validateInContext(this.context, cascadedValueContext, this.validationOrder);
        }
    }

    private final class TypeParameterValueReceiver
    implements ValueExtractor.ValueReceiver {
        private final ValidationContext<?> validationContext;
        private final ValueContext<?, Object> valueContext;
        private final MetaConstraint<?> metaConstraint;
        private boolean success = true;

        public TypeParameterValueReceiver(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext, MetaConstraint<?> metaConstraint) {
            this.validationContext = validationContext;
            this.valueContext = valueContext;
            this.metaConstraint = metaConstraint;
        }

        public void value(String nodeName, Object object) {
            this.doValidate(object, nodeName);
        }

        public void iterableValue(String nodeName, Object value) {
            this.valueContext.markCurrentPropertyAsIterable();
            this.doValidate(value, nodeName);
        }

        public void indexedValue(String nodeName, int index, Object value) {
            this.valueContext.markCurrentPropertyAsIterable();
            this.valueContext.setIndex(index);
            this.doValidate(value, nodeName);
        }

        public void keyedValue(String nodeName, Object key, Object value) {
            this.valueContext.markCurrentPropertyAsIterable();
            this.valueContext.setKey(key);
            this.doValidate(value, nodeName);
        }

        private void doValidate(Object value, String nodeName) {
            PathImpl before = this.valueContext.getPropertyPath();
            if (nodeName != null) {
                this.valueContext.appendTypeParameterNode(nodeName);
            }
            this.valueContext.setCurrentValidatedValue(value);
            this.success &= this.metaConstraint.validateConstraint(this.validationContext, this.valueContext);
            this.valueContext.setPropertyPath(before);
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

