/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.engine.cascading.ValueExtractorManager;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.ConstraintOrigin;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.core.MetaConstraints;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.TypeResolutionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public abstract class MetaDataBuilder {
    private static final Log log = LoggerFactory.make();
    protected final ConstraintHelper constraintHelper;
    protected final TypeResolutionHelper typeResolutionHelper;
    protected final ValueExtractorManager valueExtractorManager;
    private final Class<?> beanClass;
    private final Set<MetaConstraint<?>> constraints = CollectionHelper.newHashSet();
    private final Map<Class<?>, Class<?>> groupConversions = CollectionHelper.newHashMap();
    private boolean isCascading = false;

    protected MetaDataBuilder(Class<?> beanClass, ConstraintHelper constraintHelper, TypeResolutionHelper typeResolutionHelper, ValueExtractorManager valueExtractorManager) {
        this.beanClass = beanClass;
        this.constraintHelper = constraintHelper;
        this.typeResolutionHelper = typeResolutionHelper;
        this.valueExtractorManager = valueExtractorManager;
    }

    public abstract boolean accepts(ConstrainedElement var1);

    public void add(ConstrainedElement constrainedElement) {
        this.constraints.addAll(this.adaptConstraints(constrainedElement.getKind(), constrainedElement.getConstraints()));
        this.constraints.addAll(this.adaptConstraints(constrainedElement.getKind(), constrainedElement.getTypeArgumentConstraints()));
        this.isCascading = this.isCascading || constrainedElement.isCascading();
        this.addGroupConversions(constrainedElement.getGroupConversions());
    }

    public abstract ConstraintMetaData build();

    private void addGroupConversions(Map<Class<?>, Class<?>> groupConversions) {
        for (Map.Entry<Class<?>, Class<?>> oneConversion : groupConversions.entrySet()) {
            if (this.groupConversions.containsKey(oneConversion.getKey())) {
                throw log.getMultipleGroupConversionsForSameSourceException(oneConversion.getKey(), CollectionHelper.asSet(groupConversions.get(oneConversion.getKey()), oneConversion.getValue()));
            }
            this.groupConversions.put(oneConversion.getKey(), oneConversion.getValue());
        }
    }

    protected Map<Class<?>, Class<?>> getGroupConversions() {
        return this.groupConversions;
    }

    protected Set<MetaConstraint<?>> getConstraints() {
        return this.constraints;
    }

    protected boolean isCascading() {
        return this.isCascading;
    }

    protected Class<?> getBeanClass() {
        return this.beanClass;
    }

    protected Set<MetaConstraint<?>> adaptOriginsAndImplicitGroups(Set<MetaConstraint<?>> constraints) {
        HashSet<MetaConstraint<?>> adaptedConstraints = CollectionHelper.newHashSet();
        for (MetaConstraint<?> oneConstraint : constraints) {
            adaptedConstraints.add(this.adaptOriginAndImplicitGroup(oneConstraint));
        }
        return adaptedConstraints;
    }

    private <A extends Annotation> MetaConstraint<A> adaptOriginAndImplicitGroup(MetaConstraint<A> constraint) {
        ConstraintOrigin definedIn = this.definedIn(this.beanClass, constraint.getLocation().getDeclaringClass());
        if (definedIn == ConstraintOrigin.DEFINED_LOCALLY) {
            return constraint;
        }
        Class<?> constraintClass = constraint.getLocation().getDeclaringClass();
        ConstraintDescriptorImpl<A> descriptor = new ConstraintDescriptorImpl<A>(this.constraintHelper, constraint.getLocation().getMember(), constraint.getDescriptor().getAnnotation(), constraint.getElementType(), constraintClass.isInterface() ? constraintClass : null, definedIn, constraint.getDescriptor().getConstraintType());
        return MetaConstraints.create(this.typeResolutionHelper, this.valueExtractorManager, descriptor, constraint.getLocation());
    }

    protected Set<MetaConstraint<?>> adaptConstraints(ConstrainedElement.ConstrainedElementKind constrainedElementKind, Set<MetaConstraint<?>> constraints) {
        return constraints;
    }

    private ConstraintOrigin definedIn(Class<?> rootClass, Class<?> hierarchyClass) {
        if (hierarchyClass.equals(rootClass)) {
            return ConstraintOrigin.DEFINED_LOCALLY;
        }
        return ConstraintOrigin.DEFINED_IN_HIERARCHY;
    }
}

