/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.ElementType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ElementKind;
import javax.validation.metadata.GroupConversionDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import org.hibernate.validator.internal.engine.cascading.ValueExtractorManager;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.GroupConversionHelper;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ParameterDescriptorImpl;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.util.TypeResolutionHelper;

public class ParameterMetaData
extends AbstractConstraintMetaData
implements Cascadable {
    private final GroupConversionHelper groupConversionHelper;
    private final int index;
    private final List<TypeVariable<?>> cascadingTypeParameters;

    private ParameterMetaData(int index, String name, Type type, Set<MetaConstraint<?>> constraints, List<TypeVariable<?>> cascadingTypeParameters, Map<Class<?>, Class<?>> groupConversions) {
        super(name, type, constraints, ElementKind.PARAMETER, !cascadingTypeParameters.isEmpty(), !constraints.isEmpty() || !cascadingTypeParameters.isEmpty());
        this.index = index;
        this.cascadingTypeParameters = Collections.unmodifiableList(cascadingTypeParameters);
        this.groupConversionHelper = new GroupConversionHelper(groupConversions);
        this.groupConversionHelper.validateGroupConversions(this.isCascading(), this.toString());
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public Class<?> convertGroup(Class<?> originalGroup) {
        return this.groupConversionHelper.convertGroup(originalGroup);
    }

    @Override
    public Set<GroupConversionDescriptor> getGroupConversionDescriptors() {
        return this.groupConversionHelper.asDescriptors();
    }

    @Override
    public ElementType getElementType() {
        return ElementType.PARAMETER;
    }

    public ParameterDescriptor asDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        return new ParameterDescriptorImpl(this.getType(), this.index, this.getName(), this.asDescriptors(this.getConstraints()), this.isCascading(), defaultGroupSequenceRedefined, defaultGroupSequence, this.getGroupConversionDescriptors());
    }

    @Override
    public Object getValue(Object parent) {
        return ((Object[])parent)[this.getIndex()];
    }

    @Override
    public Type getCascadableType() {
        return this.getType();
    }

    @Override
    public void appendTo(PathImpl path) {
        path.addParameterNode(this.getName(), this.getIndex());
    }

    @Override
    public List<TypeVariable<?>> getCascadingTypeParameters() {
        return this.cascadingTypeParameters;
    }

    public static class Builder
    extends MetaDataBuilder {
        private final Type parameterType;
        private final int parameterIndex;
        private ConstrainedParameter constrainedParameter;
        private final List<TypeVariable<?>> cascadingTypeParameters = new ArrayList();

        public Builder(Class<?> beanClass, ConstrainedParameter constrainedParameter, ConstraintHelper constraintHelper, TypeResolutionHelper typeResolutionHelper, ValueExtractorManager valueExtractorManager) {
            super(beanClass, constraintHelper, typeResolutionHelper, valueExtractorManager);
            this.parameterType = constrainedParameter.getType();
            this.parameterIndex = constrainedParameter.getIndex();
            this.add(constrainedParameter);
        }

        @Override
        public boolean accepts(ConstrainedElement constrainedElement) {
            if (constrainedElement.getKind() != ConstrainedElement.ConstrainedElementKind.PARAMETER) {
                return false;
            }
            return ((ConstrainedParameter)constrainedElement).getIndex() == this.parameterIndex;
        }

        @Override
        public void add(ConstrainedElement constrainedElement) {
            super.add(constrainedElement);
            ConstrainedParameter newConstrainedParameter = (ConstrainedParameter)constrainedElement;
            this.cascadingTypeParameters.addAll(newConstrainedParameter.getCascadingTypeParameters());
            if (this.constrainedParameter == null) {
                this.constrainedParameter = newConstrainedParameter;
            } else if (newConstrainedParameter.getExecutable().getDeclaringClass().isAssignableFrom(this.constrainedParameter.getExecutable().getDeclaringClass())) {
                this.constrainedParameter = newConstrainedParameter;
            }
        }

        @Override
        public ParameterMetaData build() {
            return new ParameterMetaData(this.parameterIndex, this.constrainedParameter.getName(), this.parameterType, this.adaptOriginsAndImplicitGroups(this.getConstraints()), this.cascadingTypeParameters, this.getGroupConversions());
        }
    }
}

