/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.validator.internal.metadata.aggregated.ParameterMetaData;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.metadata.facets.Validatable;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.location.ParameterConstraintLocation;
import org.hibernate.validator.internal.metadata.location.TypeArgumentConstraintLocation;

public class ValidatableParametersMetaData
implements Validatable {
    private final List<ParameterMetaData> parameterMetaData;
    private final Iterable<Cascadable> cascadables;

    public ValidatableParametersMetaData(List<ParameterMetaData> parameterMetaData) {
        this.parameterMetaData = Collections.unmodifiableList(parameterMetaData);
        this.cascadables = Collections.unmodifiableList(parameterMetaData.stream().filter(p -> p.isCascading()).collect(Collectors.toList()));
    }

    @Override
    public Iterable<Cascadable> getCascadables() {
        return this.cascadables;
    }

    private ParameterConstraintLocation getParameterConstraintLocation(ConstraintLocation location) {
        if (location instanceof ParameterConstraintLocation) {
            return (ParameterConstraintLocation)location;
        }
        if (location instanceof TypeArgumentConstraintLocation) {
            return (ParameterConstraintLocation)((TypeArgumentConstraintLocation)location).getDelegate();
        }
        return null;
    }
}

