/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.core;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Type;
import java.util.Set;
import org.hibernate.validator.internal.engine.ValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.cascading.ValueExtractorDescriptor;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintTree;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;

public class MetaConstraint<A extends Annotation> {
    private final ConstraintTree<A> constraintTree;
    private final ConstraintDescriptorImpl<A> constraintDescriptor;
    private final ConstraintLocation location;
    private final ValueExtractorDescriptor valueExtractorDescriptor;

    MetaConstraint(ConstraintDescriptorImpl<A> constraintDescriptor, ConstraintLocation location, ValueExtractorDescriptor valueExtractorDescriptor, Type validatedValueType) {
        this.constraintTree = new ConstraintTree<A>(constraintDescriptor, validatedValueType);
        this.constraintDescriptor = constraintDescriptor;
        this.location = location;
        this.valueExtractorDescriptor = valueExtractorDescriptor;
    }

    public final Set<Class<?>> getGroupList() {
        return this.constraintDescriptor.getGroups();
    }

    public final ConstraintDescriptorImpl<A> getDescriptor() {
        return this.constraintDescriptor;
    }

    public final ElementType getElementType() {
        return this.constraintDescriptor.getElementType();
    }

    public boolean validateConstraint(ValidationContext<?> executionContext, ValueContext<?, ?> valueContext) {
        valueContext.setElementType(this.getElementType());
        boolean validationResult = this.constraintTree.validateConstraints(executionContext, valueContext);
        return validationResult;
    }

    public ConstraintLocation getLocation() {
        return this.location;
    }

    public ValueExtractorDescriptor getValueExtractorDescriptor() {
        return this.valueExtractorDescriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaConstraint that = (MetaConstraint)o;
        if (this.constraintDescriptor != null ? !this.constraintDescriptor.equals(that.constraintDescriptor) : that.constraintDescriptor != null) {
            return false;
        }
        if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
            return false;
        }
        return !(this.valueExtractorDescriptor != null ? !this.valueExtractorDescriptor.equals(that.valueExtractorDescriptor) : that.valueExtractorDescriptor != null);
    }

    public int hashCode() {
        int result = this.constraintDescriptor != null ? this.constraintDescriptor.hashCode() : 0;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MetaConstraint");
        sb.append("{constraintType=").append(this.constraintDescriptor.getAnnotation().annotationType().getName());
        sb.append(", location=").append(this.location);
        sb.append(", valueExtractorDescriptor=").append(this.valueExtractorDescriptor);
        sb.append("}");
        return sb.toString();
    }
}

