/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.location;

import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.util.ExecutableParameterNameProvider;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.StringHelper;

public class TypeArgumentConstraintLocation
implements ConstraintLocation {
    private final ConstraintLocation delegate;
    private final TypeVariable<?> typeParameter;
    private final Type typeForValidatorResolution;

    TypeArgumentConstraintLocation(ConstraintLocation delegate, TypeVariable<?> typeParameter, Type typeOfAnnotatedElement) {
        this.delegate = delegate;
        this.typeParameter = typeParameter;
        this.typeForValidatorResolution = ReflectionHelper.boxedType(typeOfAnnotatedElement);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.delegate.getDeclaringClass();
    }

    @Override
    public Member getMember() {
        return this.delegate.getMember();
    }

    public TypeVariable<?> getTypeParameter() {
        return this.typeParameter;
    }

    @Override
    public Type getTypeForValidatorResolution() {
        return this.typeForValidatorResolution;
    }

    @Override
    public void appendTo(ExecutableParameterNameProvider parameterNameProvider, PathImpl path) {
        this.delegate.appendTo(parameterNameProvider, path);
    }

    @Override
    public Object getValue(Object parent) {
        return this.delegate.getValue(parent);
    }

    public ConstraintLocation getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return "TypeArgumentValueConstraintLocation [delegate=" + this.delegate + ", typeForValidatorResolution=" + StringHelper.toShortString(this.typeForValidatorResolution) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeArgumentConstraintLocation that = (TypeArgumentConstraintLocation)o;
        if (this.delegate != null ? !this.delegate.equals(that.delegate) : that.delegate != null) {
            return false;
        }
        return this.typeForValidatorResolution.equals(that.typeForValidatorResolution);
    }

    public int hashCode() {
        int result = this.delegate != null ? this.delegate.hashCode() : 0;
        result = 31 * result + this.typeForValidatorResolution.hashCode();
        return result;
    }
}

