/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.lang.annotation.ElementType;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.internal.engine.cascading.AnnotatedObject;
import org.hibernate.validator.internal.engine.cascading.ArrayElement;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ExecutableParameterNameProvider;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.xml.GroupConversionBuilder;
import org.hibernate.validator.internal.xml.MetaConstraintBuilder;
import org.hibernate.validator.internal.xml.binding.ConstraintType;
import org.hibernate.validator.internal.xml.binding.ParameterType;

class ConstrainedParameterBuilder {
    private final GroupConversionBuilder groupConversionBuilder;
    private final ExecutableParameterNameProvider parameterNameProvider;
    private final MetaConstraintBuilder metaConstraintBuilder;
    private final AnnotationProcessingOptionsImpl annotationProcessingOptions;

    ConstrainedParameterBuilder(MetaConstraintBuilder metaConstraintBuilder, ExecutableParameterNameProvider parameterNameProvider, GroupConversionBuilder groupConversionBuilder, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        this.metaConstraintBuilder = metaConstraintBuilder;
        this.parameterNameProvider = parameterNameProvider;
        this.groupConversionBuilder = groupConversionBuilder;
        this.annotationProcessingOptions = annotationProcessingOptions;
    }

    List<ConstrainedParameter> buildConstrainedParameters(List<ParameterType> parameterList, Executable executable, String defaultPackage) {
        ArrayList<ConstrainedParameter> constrainedParameters = CollectionHelper.newArrayList();
        int i = 0;
        List<String> parameterNames = this.parameterNameProvider.getParameterNames(executable);
        for (ParameterType parameterType : parameterList) {
            ConstraintLocation constraintLocation = ConstraintLocation.forParameter(executable, i);
            HashSet<MetaConstraint<?>> metaConstraints = CollectionHelper.newHashSet();
            for (ConstraintType constraint : parameterType.getConstraint()) {
                MetaConstraint metaConstraint = this.metaConstraintBuilder.buildMetaConstraint(constraintLocation, constraint, ElementType.PARAMETER, defaultPackage, null);
                metaConstraints.add(metaConstraint);
            }
            Map<Class<?>, Class<?>> groupConversions = this.groupConversionBuilder.buildGroupConversionMap(parameterType.getConvertGroup(), defaultPackage);
            if (parameterType.getIgnoreAnnotations() != null) {
                this.annotationProcessingOptions.ignoreConstraintAnnotationsOnParameter(executable, i, parameterType.getIgnoreAnnotations());
            }
            Type type = ReflectionHelper.typeOf(executable, i);
            ConstrainedParameter constrainedParameter = new ConstrainedParameter(ConfigurationSource.XML, executable, type, i, parameterNames.get(i), metaConstraints, Collections.emptySet(), groupConversions, this.getCascadedTypeParameters(type, parameterType.getValid() != null));
            constrainedParameters.add(constrainedParameter);
            ++i;
        }
        return constrainedParameters;
    }

    private List<TypeVariable<?>> getCascadedTypeParameters(Type parameterType, boolean isCascaded) {
        if (isCascaded) {
            return Collections.singletonList(ReflectionHelper.getClassFromType(parameterType).isArray() ? ArrayElement.INSTANCE : AnnotatedObject.INSTANCE);
        }
        return Collections.emptyList();
    }
}

