/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.testutil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import org.hibernate.validator.internal.engine.PathImpl;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.method.MethodConstraintViolationException;
import org.testng.Assert;

public final class ConstraintViolationAssert {
    private ConstraintViolationAssert() {
    }

    public static void assertCorrectConstraintViolationMessages(Set<? extends ConstraintViolation<?>> violations, String ... expectedMessages) {
        List<String> expectedMessagesAsList = Arrays.asList(expectedMessages);
        ArrayList actualMessages = CollectionHelper.newArrayList();
        for (ConstraintViolation<?> violation : violations) {
            actualMessages.add(violation.getMessage());
        }
        Collections.sort(expectedMessagesAsList);
        Collections.sort(actualMessages);
        Assert.assertEquals((Collection)actualMessages, expectedMessagesAsList);
    }

    public static void assertCorrectConstraintViolationMessages(MethodConstraintViolationException e, String ... expectedMessages) {
        ConstraintViolationAssert.assertCorrectConstraintViolationMessages(e.getConstraintViolations(), expectedMessages);
    }

    public static <T> void assertCorrectConstraintTypes(Set<ConstraintViolation<T>> violations, Class<?> ... expectedConstraintTypes) {
        ArrayList expectedConstraintTypeNames = CollectionHelper.newArrayList();
        for (Class<?> oneExpectedConstraintType : expectedConstraintTypes) {
            expectedConstraintTypeNames.add(oneExpectedConstraintType.getName());
        }
        ArrayList actualConstraintTypeNames = CollectionHelper.newArrayList();
        for (ConstraintViolation<T> violation : violations) {
            actualConstraintTypeNames.add(violation.getConstraintDescriptor().getAnnotation().annotationType().getName());
        }
        Collections.sort(expectedConstraintTypeNames);
        Collections.sort(actualConstraintTypeNames);
        Assert.assertEquals((Collection)actualConstraintTypeNames, (Collection)expectedConstraintTypeNames);
    }

    public static void assertCorrectPropertyPaths(Set<? extends ConstraintViolation<?>> violations, String ... expectedPropertyPaths) {
        List<String> expectedPathsAsList = Arrays.asList(expectedPropertyPaths);
        ArrayList actualPaths = CollectionHelper.newArrayList();
        for (ConstraintViolation<?> violation : violations) {
            actualPaths.add(violation.getPropertyPath().toString());
        }
        Collections.sort(expectedPathsAsList);
        Collections.sort(actualPaths);
        Assert.assertEquals((Collection)actualPaths, expectedPathsAsList);
    }

    public static void assertCorrectPropertyPaths(MethodConstraintViolationException e, String ... expectedPropertyPaths) {
        ConstraintViolationAssert.assertCorrectPropertyPaths(e.getConstraintViolations(), expectedPropertyPaths);
    }

    public static void assertConstraintViolation(ConstraintViolation<?> violation, String errorMessage, Class<?> rootBeanClass, Object invalidValue, String propertyPath) {
        Assert.assertTrue((boolean)ConstraintViolationAssert.pathsAreEqual(violation.getPropertyPath(), (Path)PathImpl.createPathFromString((String)propertyPath)), (String)"Wrong propertyPath");
        ConstraintViolationAssert.assertConstraintViolation(violation, errorMessage, rootBeanClass, invalidValue);
    }

    public static void assertConstraintViolation(ConstraintViolation<?> violation, String errorMessage, Class<?> rootBeanClass, Object invalidValue) {
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)invalidValue, (String)"Wrong invalid value");
        ConstraintViolationAssert.assertConstraintViolation(violation, errorMessage, rootBeanClass);
    }

    public static void assertConstraintViolation(ConstraintViolation<?> violation, String errorMessage, Class<?> rootBeanClass) {
        Assert.assertEquals(violation.getRootBean().getClass(), rootBeanClass, (String)"Wrong root bean type");
        ConstraintViolationAssert.assertConstraintViolation(violation, errorMessage);
    }

    public static void assertConstraintViolation(ConstraintViolation<?> violation, String errorMessage) {
        Assert.assertEquals((String)violation.getMessage(), (String)errorMessage, (String)"Wrong expectedMessage");
    }

    public static void assertNumberOfViolations(Set<? extends ConstraintViolation<?>> violations, int numberOfViolations) {
        Assert.assertEquals((int)violations.size(), (int)numberOfViolations, (String)"Wrong number of constraint violations");
    }

    public static boolean pathsAreEqual(Path p1, Path p2) {
        Iterator p1Iterator = p1.iterator();
        Iterator p2Iterator = p2.iterator();
        while (p1Iterator.hasNext()) {
            Path.Node p1Node = (Path.Node)p1Iterator.next();
            if (!p2Iterator.hasNext()) {
                return false;
            }
            Path.Node p2Node = (Path.Node)p2Iterator.next();
            if (p2Node.getName() == null ? p1Node.getName() != null : !p2Node.getName().equals(p1Node.getName())) {
                return false;
            }
            if (p2Node.isInIterable() != p1Node.isInIterable()) {
                return false;
            }
            if (p2Node.getIndex() == null ? p1Node.getIndex() != null : !p2Node.getIndex().equals(p1Node.getIndex())) {
                return false;
            }
            if (!(p2Node.getKey() == null ? p1Node.getKey() != null : !p2Node.getKey().equals(p1Node.getKey()))) continue;
            return false;
        }
        return !p2Iterator.hasNext();
    }

    public static void assertIterableSize(Iterable<?> iterable, int size) {
        int i = 0;
        for (Object o : iterable) {
            ++i;
        }
        Assert.assertEquals((int)i, (int)size, (String)("Actual size of iterable [" + iterable + "] differed from expected size"));
    }
}

