/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.testutil;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.metadata.ConstraintDescriptor;
import org.fest.assertions.CollectionAssert;
import org.fest.assertions.Formatting;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.testng.Assert;

public final class ConstraintViolationAssert {
    private static final String CROSS_PARAMETER_NODE_NAME = "<cross-parameter>";

    private ConstraintViolationAssert() {
    }

    public static void assertCorrectConstraintViolationMessages(Set<? extends ConstraintViolation<?>> violations, String ... expectedMessages) {
        List<String> expectedMessagesAsList = Arrays.asList(expectedMessages);
        ArrayList actualMessages = CollectionHelper.newArrayList();
        for (ConstraintViolation<?> violation : violations) {
            actualMessages.add(violation.getMessage());
        }
        Collections.sort(expectedMessagesAsList);
        Collections.sort(actualMessages);
        Assert.assertEquals((Collection)actualMessages, expectedMessagesAsList);
    }

    public static void assertCorrectConstraintViolationMessages(ConstraintViolationException e, String ... expectedMessages) {
        ConstraintViolationAssert.assertCorrectConstraintViolationMessages(e.getConstraintViolations(), expectedMessages);
    }

    public static <T> void assertCorrectConstraintTypes(Set<ConstraintViolation<T>> violations, Class<?> ... expectedConstraintTypes) {
        ArrayList actualConstraintTypes = CollectionHelper.newArrayList();
        for (ConstraintViolation<T> violation : violations) {
            actualConstraintTypes.add(violation.getConstraintDescriptor().getAnnotation().annotationType());
        }
        ConstraintViolationAssert.assertCorrectConstraintTypes(actualConstraintTypes, expectedConstraintTypes);
    }

    public static void assertCorrectPropertyPaths(Set<? extends ConstraintViolation<?>> violations, String ... expectedPropertyPaths) {
        List<String> expectedPathsAsList = Arrays.asList(expectedPropertyPaths);
        ArrayList actualPaths = CollectionHelper.newArrayList();
        for (ConstraintViolation<?> violation : violations) {
            actualPaths.add(violation.getPropertyPath().toString());
        }
        Collections.sort(expectedPathsAsList);
        Collections.sort(actualPaths);
        Assert.assertEquals((Collection)actualPaths, expectedPathsAsList);
    }

    public static ConstraintViolationSetAssert assertThat(Set<? extends ConstraintViolation<?>> actualViolations) {
        return new ConstraintViolationSetAssert(actualViolations);
    }

    public static void assertCorrectPropertyPaths(ConstraintViolationException e, String ... expectedPropertyPaths) {
        ConstraintViolationAssert.assertCorrectPropertyPaths(e.getConstraintViolations(), expectedPropertyPaths);
    }

    public static void assertConstraintViolation(ConstraintViolation<?> violation, String errorMessage, Class<?> rootBeanClass, Object invalidValue, String propertyPath) {
        Assert.assertTrue((boolean)ConstraintViolationAssert.pathsAreEqual(violation.getPropertyPath(), (Path)PathImpl.createPathFromString((String)propertyPath)), (String)"Wrong propertyPath");
        ConstraintViolationAssert.assertConstraintViolation(violation, errorMessage, rootBeanClass, invalidValue);
    }

    public static void assertConstraintViolation(ConstraintViolation<?> violation, String errorMessage, Class<?> rootBeanClass, Object invalidValue) {
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)invalidValue, (String)"Wrong invalid value");
        ConstraintViolationAssert.assertConstraintViolation(violation, errorMessage, rootBeanClass);
    }

    public static void assertConstraintViolation(ConstraintViolation<?> violation, String errorMessage, Class<?> rootBeanClass) {
        Assert.assertEquals(violation.getRootBean().getClass(), rootBeanClass, (String)"Wrong root bean type");
        ConstraintViolationAssert.assertConstraintViolation(violation, errorMessage);
    }

    public static void assertConstraintViolation(ConstraintViolation<?> violation, String errorMessage) {
        Assert.assertEquals((String)violation.getMessage(), (String)errorMessage, (String)"Wrong expectedMessage");
    }

    public static void assertNumberOfViolations(Set<? extends ConstraintViolation<?>> violations, int numberOfViolations) {
        Assert.assertEquals((int)violations.size(), (int)numberOfViolations, (String)"Wrong number of constraint violations");
    }

    public static void assertConstraintTypes(Set<ConstraintDescriptor<?>> descriptors, Class<?> ... expectedConstraintTypes) {
        ArrayList actualConstraintTypes = CollectionHelper.newArrayList();
        for (ConstraintDescriptor<?> descriptor : descriptors) {
            actualConstraintTypes.add(descriptor.getAnnotation().annotationType());
        }
        ConstraintViolationAssert.assertCorrectConstraintTypes(actualConstraintTypes, expectedConstraintTypes);
    }

    public static void assertNodeKinds(Path path, ElementKind ... kinds) {
        Iterator pathIterator = path.iterator();
        for (ElementKind kind : kinds) {
            Assert.assertTrue((boolean)pathIterator.hasNext());
            Assert.assertEquals((Object)((Path.Node)pathIterator.next()).getKind(), (Object)kind);
        }
        Assert.assertFalse((boolean)pathIterator.hasNext());
    }

    public static void assertNodeNames(Path path, String ... names) {
        Iterator pathIterator = path.iterator();
        for (String name : names) {
            Assert.assertTrue((boolean)pathIterator.hasNext());
            Assert.assertEquals((String)((Path.Node)pathIterator.next()).getName(), (String)name);
        }
        Assert.assertFalse((boolean)pathIterator.hasNext());
    }

    public static boolean pathsAreEqual(Path p1, Path p2) {
        Iterator p1Iterator = p1.iterator();
        Iterator p2Iterator = p2.iterator();
        while (p1Iterator.hasNext()) {
            Path.Node p1Node = (Path.Node)p1Iterator.next();
            if (!p2Iterator.hasNext()) {
                return false;
            }
            Path.Node p2Node = (Path.Node)p2Iterator.next();
            if (p2Node.getName() == null ? p1Node.getName() != null : !p2Node.getName().equals(p1Node.getName())) {
                return false;
            }
            if (p2Node.isInIterable() != p1Node.isInIterable()) {
                return false;
            }
            if (p2Node.getIndex() == null ? p1Node.getIndex() != null : !p2Node.getIndex().equals(p1Node.getIndex())) {
                return false;
            }
            if (!(p2Node.getKey() == null ? p1Node.getKey() != null : !p2Node.getKey().equals(p1Node.getKey()))) continue;
            return false;
        }
        return !p2Iterator.hasNext();
    }

    private static <T> void assertCorrectConstraintTypes(Iterable<Class<? extends Annotation>> actualConstraintTypes, Class<?> ... expectedConstraintTypes) {
        ArrayList expectedConstraintTypeNames = CollectionHelper.newArrayList();
        for (Class<?> expectedConstraintType : expectedConstraintTypes) {
            expectedConstraintTypeNames.add(expectedConstraintType.getName());
        }
        ArrayList actualConstraintTypeNames = CollectionHelper.newArrayList();
        for (Class<? extends Annotation> actualConstraintType : actualConstraintTypes) {
            actualConstraintTypeNames.add(actualConstraintType.getName());
        }
        Collections.sort(expectedConstraintTypeNames);
        Collections.sort(actualConstraintTypeNames);
        Assert.assertEquals((Collection)actualConstraintTypeNames, (Collection)expectedConstraintTypeNames, (String)String.format("Expected %s, but got %s", expectedConstraintTypeNames, actualConstraintTypeNames));
    }

    public static PathExpectation pathWith() {
        return new PathExpectation();
    }

    private static class NodeExpectation {
        private final String name;
        private final ElementKind kind;
        private final boolean inIterable;
        private final Object key;
        private final Integer index;
        private final Integer parameterIndex;

        private NodeExpectation(String name, ElementKind kind, boolean inIterable, Object key, Integer index, Integer parameterIndex) {
            this.name = name;
            this.kind = kind;
            this.inIterable = inIterable;
            this.key = key;
            this.index = index;
            this.parameterIndex = parameterIndex;
        }

        public String toString() {
            return "NodeExpectation(" + this.name + ", " + this.kind + ", " + this.inIterable + ", " + this.key + ", " + this.index + ", " + this.parameterIndex + ")";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.inIterable ? 1231 : 1237);
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.parameterIndex == null ? 0 : this.parameterIndex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeExpectation other = (NodeExpectation)obj;
            if (this.inIterable != other.inIterable) {
                return false;
            }
            if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.kind != other.kind) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.parameterIndex == null ? other.parameterIndex != null : !this.parameterIndex.equals(other.parameterIndex));
        }
    }

    public static class PathExpectation {
        private final List<NodeExpectation> nodes = CollectionHelper.newArrayList();

        private PathExpectation() {
        }

        private PathExpectation(Path propertyPath) {
            for (Path.Node node : propertyPath) {
                Integer parameterIndex = null;
                if (node.getKind() == ElementKind.PARAMETER) {
                    parameterIndex = ((Path.ParameterNode)node.as(Path.ParameterNode.class)).getParameterIndex();
                }
                this.nodes.add(new NodeExpectation(node.getName(), node.getKind(), node.isInIterable(), node.getKey(), node.getIndex(), parameterIndex));
            }
        }

        public PathExpectation property(String name) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PROPERTY, false, null, null, null));
            return this;
        }

        public PathExpectation property(String name, boolean inIterable, Object key, Integer index) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PROPERTY, inIterable, key, index, null));
            return this;
        }

        public PathExpectation bean() {
            this.nodes.add(new NodeExpectation(null, ElementKind.BEAN, false, null, null, null));
            return this;
        }

        public PathExpectation bean(boolean inIterable, Object key, Integer index) {
            this.nodes.add(new NodeExpectation(null, ElementKind.BEAN, inIterable, key, index, null));
            return this;
        }

        public PathExpectation method(String name) {
            this.nodes.add(new NodeExpectation(name, ElementKind.METHOD, false, null, null, null));
            return this;
        }

        public PathExpectation parameter(String name, int index) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PARAMETER, false, null, null, index));
            return this;
        }

        public PathExpectation crossParameter() {
            this.nodes.add(new NodeExpectation(ConstraintViolationAssert.CROSS_PARAMETER_NODE_NAME, ElementKind.CROSS_PARAMETER, false, null, null, null));
            return this;
        }

        public String toString() {
            String lineBreak = System.getProperty("line.separator");
            StringBuilder asString = new StringBuilder(lineBreak + "PathExpectation(" + lineBreak);
            for (NodeExpectation node : this.nodes) {
                asString.append("  ").append(node).append(lineBreak);
            }
            return asString.append(")").toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathExpectation other = (PathExpectation)obj;
            return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
        }
    }

    public static class ConstraintViolationSetAssert
    extends CollectionAssert {
        private final Set<? extends ConstraintViolation<?>> actualViolations;

        protected ConstraintViolationSetAssert(Set<? extends ConstraintViolation<?>> actualViolations) {
            super(actualViolations);
            this.actualViolations = actualViolations;
        }

        public void containsOnlyPaths(PathExpectation ... paths) {
            this.isNotNull();
            List<PathExpectation> expectedPaths = Arrays.asList(paths);
            ArrayList actualPaths = CollectionHelper.newArrayList();
            for (ConstraintViolation<?> violation : this.actualViolations) {
                actualPaths.add(new PathExpectation(violation.getPropertyPath()));
            }
            ArrayList actualPathsTmp = new ArrayList(actualPaths);
            actualPathsTmp.removeAll(expectedPaths);
            if (!actualPathsTmp.isEmpty()) {
                this.fail(Formatting.format((String)"Found unexpected path(s): <%s>. Expected: <%s>", (Object[])new Object[]{actualPathsTmp, expectedPaths}));
            }
            ArrayList<PathExpectation> expectedPathsTmp = new ArrayList<PathExpectation>(expectedPaths);
            expectedPathsTmp.removeAll(actualPaths);
            if (!expectedPathsTmp.isEmpty()) {
                this.fail(Formatting.format((String)"Missing expected path(s) <%s>. Actual paths: <%s>", (Object[])new Object[]{expectedPathsTmp, actualPaths}));
            }
        }

        public void containsPath(PathExpectation expectedPath) {
            this.isNotNull();
            ArrayList actualPaths = CollectionHelper.newArrayList();
            for (ConstraintViolation<?> violation : this.actualViolations) {
                PathExpectation actual = new PathExpectation(violation.getPropertyPath());
                if (actual.equals(expectedPath)) {
                    return;
                }
                actualPaths.add(actual);
            }
            this.fail(Formatting.format((String)"Didn't find path <%s> in actual paths <%s>.", (Object[])new Object[]{expectedPath, actualPaths}));
        }

        public void containsPaths(PathExpectation ... expectedPaths) {
            for (PathExpectation pathExpectation : expectedPaths) {
                this.containsPath(pathExpectation);
            }
        }
    }
}

