/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.engine;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.event.RowSelectionHandler;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.MosaicPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.ConsoleConfig;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.engine.DeleteDeploymentAction;
import org.jboss.bpm.console.client.engine.DeploymentDetailView;
import org.jboss.bpm.console.client.engine.DeploymentListView;
import org.jboss.bpm.console.client.engine.ResumeDeploymentAction;
import org.jboss.bpm.console.client.engine.SuspendDeploymentAction;
import org.jboss.bpm.console.client.engine.UpdateDeploymentDetailAction;
import org.jboss.bpm.console.client.engine.UpdateDeploymentsAction;
import org.jboss.bpm.console.client.model.DeploymentRef;
import org.jboss.bpm.console.client.util.SimpleDateFormat;
import org.jboss.errai.workspaces.client.api.ProvisioningCallback;
import org.jboss.errai.workspaces.client.api.WidgetProvider;
import org.jboss.errai.workspaces.client.framework.Registry;

public class DeploymentListView
implements ViewInterface,
WidgetProvider,
DataDriven {
    public static final String ID = DeploymentListView.class.getName();
    private Controller controller;
    private boolean initialized;
    private MosaicPanel deploymentList = null;
    private org.gwt.mosaic.ui.client.ListBox<DeploymentRef> listBox;
    private DeploymentRef selection = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private int FILTER_NONE = 10;
    private int FILTER_ACTIVE = 20;
    private int FILTER_SUSPENDED = 30;
    private int currentFilter = this.FILTER_NONE;
    private List<DeploymentRef> deployments = null;
    private DeploymentDetailView detailView;
    MosaicPanel panel;
    private boolean isRiftsawInstance = false;

    public DeploymentListView() {
        this.controller = (Controller)Registry.get(Controller.class);
        ConsoleConfig config = ((ApplicationContext)Registry.get(ApplicationContext.class)).getConfig();
        this.isRiftsawInstance = config.getProfileName().equals("BPEL Console");
    }

    public void provideWidget(ProvisioningCallback callback) {
        this.panel = new MosaicPanel((LayoutManager)new BorderLayout());
        this.panel.getElement().setId("deployment-list-view");
        this.listBox = this.createListBox();
        this.initialize();
        this.panel.add((Widget)this.deploymentList, (LayoutData)new BorderLayoutData(BorderLayout.Region.CENTER));
        this.panel.add((Widget)this.detailView, (LayoutData)new BorderLayoutData(BorderLayout.Region.SOUTH, 200.0));
        this.controller.addAction(UpdateDeploymentsAction.ID, (ActionInterface)new UpdateDeploymentsAction());
        this.controller.addAction(UpdateDeploymentDetailAction.ID, (ActionInterface)new UpdateDeploymentDetailAction());
        this.controller.addAction(DeleteDeploymentAction.ID, (ActionInterface)new DeleteDeploymentAction());
        this.controller.addAction(SuspendDeploymentAction.ID, (ActionInterface)new SuspendDeploymentAction());
        this.controller.addAction(ResumeDeploymentAction.ID, (ActionInterface)new ResumeDeploymentAction());
        this.controller.addView(ID, (ViewInterface)this);
        callback.onSuccess((Widget)this.panel);
    }

    private org.gwt.mosaic.ui.client.ListBox createListBox() {
        org.gwt.mosaic.ui.client.ListBox listBox = new org.gwt.mosaic.ui.client.ListBox(new String[]{"Deployment", "Status"});
        listBox.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
        listBox.addRowSelectionHandler((RowSelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        return listBox;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (!this.initialized) {
            this.deploymentList = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            this.deploymentList.setPadding(0);
            this.deploymentList.setWidgetSpacing(0);
            MosaicPanel toolBox = new MosaicPanel();
            toolBox.setPadding(0);
            toolBox.setWidgetSpacing(0);
            toolBox.setLayout((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
            ToolBar toolBar = new ToolBar();
            toolBar.add((Widget)new Button("Refresh", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
            Button deleteBtn = new Button("Delete", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            if (!this.isRiftsawInstance) {
                toolBar.add((Widget)deleteBtn);
            }
            toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            MosaicPanel filterPanel = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            filterPanel.setStyleName("mosaic-ToolBar");
            ListBox dropBox = new ListBox(false);
            dropBox.setStyleName("bpm-operation-ui");
            dropBox.addItem("All");
            dropBox.addItem("Active");
            dropBox.addItem("Retired");
            dropBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            filterPanel.add((Widget)dropBox);
            toolBox.add((Widget)filterPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.VERTICAL));
            this.deploymentList.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.deploymentList.add((Widget)this.listBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            this.detailView = new DeploymentDetailView();
            this.controller.addView(DeploymentDetailView.ID, (ViewInterface)this.detailView);
            6 t = new /* Unavailable Anonymous Inner Class!! */;
            t.schedule(500);
            this.initialized = true;
        }
    }

    public DeploymentRef getSelection() {
        DeploymentRef selection = null;
        if (this.isInitialized() && this.listBox.getSelectedIndex() != -1) {
            selection = (DeploymentRef)this.listBox.getItem(this.listBox.getSelectedIndex());
        }
        return selection;
    }

    public void reset() {
        DefaultListModel model = (DefaultListModel)this.listBox.getModel();
        model.clear();
        this.controller.handleEvent(new Event(UpdateDeploymentDetailAction.ID, null));
    }

    public void update(Object ... data) {
        this.deployments = (List)data[0];
        this.renderFiltered();
    }

    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.deploymentList, (boolean)isLoading);
    }

    private void renderFiltered() {
        if (this.deployments != null) {
            this.reset();
            DefaultListModel model = (DefaultListModel)this.listBox.getModel();
            for (DeploymentRef dpl : this.deployments) {
                boolean showSuspended;
                if (this.FILTER_NONE == this.currentFilter) {
                    model.add((Object)dpl);
                    continue;
                }
                boolean bl = showSuspended = this.FILTER_SUSPENDED == this.currentFilter;
                if (dpl.isSuspended() != showSuspended) continue;
                model.add((Object)dpl);
            }
            if (this.listBox.getSelectedIndex() != -1) {
                this.listBox.setItemSelected(this.listBox.getSelectedIndex(), false);
            }
        }
    }

    public void select(String deploymentId) {
        DefaultListModel model = (DefaultListModel)this.listBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            DeploymentRef ref = (DeploymentRef)model.getElementAt(i);
            if (!ref.getId().equals(deploymentId)) continue;
            this.listBox.setSelectedIndex(i);
            break;
        }
    }

    static /* synthetic */ Controller access$000(DeploymentListView x0) {
        return x0.controller;
    }

    static /* synthetic */ int access$102(DeploymentListView x0, int x1) {
        x0.currentFilter = x1;
        return x0.currentFilter;
    }

    static /* synthetic */ int access$200(DeploymentListView x0) {
        return x0.FILTER_NONE;
    }

    static /* synthetic */ int access$300(DeploymentListView x0) {
        return x0.FILTER_ACTIVE;
    }

    static /* synthetic */ int access$400(DeploymentListView x0) {
        return x0.FILTER_SUSPENDED;
    }

    static /* synthetic */ void access$500(DeploymentListView x0) {
        x0.renderFiltered();
    }
}

