/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.IOUtils;
import org.jboss.bpm.console.server.RestProxyAuthProvider;
import org.overlord.commons.config.ConfigurationFactory;

public class RestProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 8689929059530563599L;
    public static final String CONFIG_FILE_NAME = "bpel-console.config.file.name";
    public static final String CONFIG_FILE_REFRESH = "bpel-console.config.file.refresh";
    public static final String PROXY_URL = "bpel-console.rest-proxy.proxy-url";
    public static final String AUTH_PROVIDER = "bpel-console.rest-proxy.authentication.provider";
    public static final String BASIC_AUTH_USER = "bpel-console.rest-proxy.authentication.basic.user";
    public static final String BASIC_AUTH_PASS = "bpel-console.rest-proxy.authentication.basic.password";
    private static final Set<String> excludedRequestHeaders = new HashSet();
    private static final Set<String> excludedResponseHeaders = new HashSet();
    public static Configuration appconfig;
    private String proxyUrl;
    private String authProviderClassName;
    private Map<String, String> params = new HashMap();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.proxyUrl = appconfig.getString(PROXY_URL);
        if (this.proxyUrl == null) {
            throw new ServletException("Missing config property: bpel-console.rest-proxy.proxy-url");
        }
        this.authProviderClassName = appconfig.getString(AUTH_PROVIDER);
        Iterator keys = appconfig.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String val = appconfig.getString(key);
            this.params.put(key, val);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.proxyRequest(req, resp, true);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.proxyRequest(req, resp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyRequest(HttpServletRequest req, HttpServletResponse resp, boolean isPost) throws MalformedURLException, IOException, ProtocolException, ServletException {
        String queryString;
        String pathInfo;
        String urlStr = this.getProxyUrl(req);
        if (urlStr.endsWith("/")) {
            urlStr = urlStr.substring(0, urlStr.length() - 1);
        }
        if ((pathInfo = req.getPathInfo()) != null) {
            urlStr = urlStr + pathInfo;
        }
        if ((queryString = req.getQueryString()) != null) {
            urlStr = urlStr + "?" + queryString;
        }
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (isPost) {
            conn.setDoOutput(true);
        }
        conn.setRequestMethod("GET");
        String cookie = (String)req.getSession().getAttribute("PROXY_COOKIE");
        if (cookie != null) {
            conn.addRequestProperty("Cookie", cookie);
        }
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = String.valueOf(headerNames.nextElement());
            if (excludedRequestHeaders.contains(headerName.toLowerCase())) continue;
            Enumeration headerValues = req.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = String.valueOf(headerValues.nextElement());
                conn.addRequestProperty(headerName, headerValue);
            }
        }
        RestProxyAuthProvider authProvider = this.getAuthProvider();
        if (authProvider != null) {
            authProvider.provideAuthentication(conn);
        }
        if (isPost) {
            ServletInputStream is = null;
            is = req.getInputStream();
            IOUtils.copy((InputStream)is, (OutputStream)conn.getOutputStream());
        }
        InputStream proxyUrlResponseStream = null;
        try {
            proxyUrlResponseStream = conn.getInputStream();
            resp.setStatus(conn.getResponseCode());
            for (Map.Entry<String, List<String>> entry : conn.getHeaderFields().entrySet()) {
                String respHeaderName = entry.getKey();
                if (respHeaderName != null && !excludedResponseHeaders.contains(respHeaderName.toLowerCase())) {
                    for (String respHeaderValue : entry.getValue()) {
                        resp.addHeader(respHeaderName, respHeaderValue);
                    }
                }
                if (!"set-cookie".equalsIgnoreCase(respHeaderName)) continue;
                cookie = entry.getValue().get(0);
                req.getSession().setAttribute("PROXY_COOKIE", (Object)cookie);
            }
            IOUtils.copy((InputStream)proxyUrlResponseStream, (OutputStream)resp.getOutputStream());
        }
        finally {
            IOUtils.closeQuietly((InputStream)proxyUrlResponseStream);
            conn.disconnect();
        }
    }

    private String getProxyUrl(HttpServletRequest req) {
        String scheme = req.getScheme();
        String host = req.getServerName();
        String port = String.valueOf(req.getServerPort());
        return this.proxyUrl.replace("SCHEME", scheme).replace("HOST", host).replace("PORT", port);
    }

    private RestProxyAuthProvider getAuthProvider() throws ServletException {
        String classname = this.authProviderClassName;
        if (classname != null) {
            try {
                Class<?> authProviderClass = Class.forName(classname);
                RestProxyAuthProvider authProvider = (RestProxyAuthProvider)authProviderClass.newInstance();
                authProvider.setConfiguration(this.params);
                return authProvider;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        return null;
    }

    static {
        String configFile = System.getProperty(CONFIG_FILE_NAME);
        String refreshDelayStr = System.getProperty(CONFIG_FILE_REFRESH);
        Long refreshDelay = 5000L;
        if (refreshDelayStr != null) {
            refreshDelay = new Long(refreshDelayStr);
        }
        appconfig = ConfigurationFactory.createConfig((String)configFile, (String)"bpel-console.properties", (Long)refreshDelay, null, RestProxyServlet.class);
        excludedRequestHeaders.add("cookie");
        excludedResponseHeaders.add("set-cookie");
        excludedResponseHeaders.add("transfer-encoding");
    }
}

