/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.version;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.ext.editor.commons.backend.version.MockIOService;
import org.uberfire.ext.editor.commons.backend.version.VersionRecordServiceImpl;
import org.uberfire.ext.editor.commons.backend.version.VersionUtil;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionAttributes;
import org.uberfire.java.nio.base.version.VersionHistory;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttributeView;
import org.uberfire.java.nio.file.attribute.FileTime;

public class VersionRecordServiceImplTest {
    private MockIOService ioService;
    private Path pathToFile;
    private Path pathToDotFile;
    private ArrayList<VersionRecord> dotFileVersionRecords = new ArrayList();
    private ArrayList<VersionRecord> mainFileVersionRecords = new ArrayList();

    @Before
    public void setUp() throws Exception {
        this.pathToFile = (Path)Mockito.mock(Path.class);
        this.pathToDotFile = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.pathToFile.resolveSibling(Mockito.anyString())).thenReturn((Object)this.pathToDotFile);
        this.ioService = new MockIOService(){

            @Override
            public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> vClass) throws IllegalArgumentException {
                return (V)((Object)new MockVersionAttributeView(path));
            }
        };
        this.mainFileVersionRecords.add(this.makeVersionRecord("id1", "file.txt", new Date(1L)));
        this.mainFileVersionRecords.add(this.makeVersionRecord("id3", "file.txt", new Date(3L)));
        this.mainFileVersionRecords.add(this.makeVersionRecord("id4", "file.txt", new Date(4L)));
        this.dotFileVersionRecords.add(this.makeVersionRecord("id1", ".file.txt", new Date(1L)));
        this.dotFileVersionRecords.add(this.makeVersionRecord("id2", ".file.txt", new Date(2L)));
        this.dotFileVersionRecords.add(this.makeVersionRecord("id5", ".file.txt", new Date(5L)));
    }

    @Test
    public void testSimple() throws Exception {
        this.ioService.setExistingPaths(this.pathToFile, this.pathToDotFile);
        VersionRecordServiceImpl versionRecordServiceImpl = new VersionRecordServiceImpl((IOService)this.ioService, new VersionUtil());
        List versions = versionRecordServiceImpl.load(this.pathToFile);
        Assert.assertEquals((long)5L, (long)versions.size());
        Assert.assertEquals((Object)"id1", (Object)((VersionRecord)versions.get(0)).id());
        Assert.assertEquals((Object)"id2", (Object)((VersionRecord)versions.get(1)).id());
        Assert.assertEquals((Object)"id3", (Object)((VersionRecord)versions.get(2)).id());
        Assert.assertEquals((Object)"id4", (Object)((VersionRecord)versions.get(3)).id());
        Assert.assertEquals((Object)"id5", (Object)((VersionRecord)versions.get(4)).id());
    }

    @Test
    public void testMainFileHasHigherPriorityWhenCommitTimeIsEqual() throws Exception {
        this.ioService.setExistingPaths(this.pathToFile, this.pathToDotFile);
        this.mainFileVersionRecords.clear();
        this.dotFileVersionRecords.clear();
        this.mainFileVersionRecords.add(this.makeVersionRecord("main file", "default://f6d48ce4c00a915185668c8df33bb500b3889c95@uf-playground/mortgages/src/main/resources/org/mortgages/Bankruptcy%20history.rdrl", new Date(1L)));
        this.dotFileVersionRecords.add(this.makeVersionRecord("dot1 file", "default://f6d48ce4c00a915185668c8df33bb500b3889c95@uf-playground/mortgages/src/main/resources/org/mortgages/.Bankruptcy%20history.rdrl", new Date(1L)));
        VersionRecordServiceImpl versionRecordServiceImpl = new VersionRecordServiceImpl((IOService)this.ioService, new VersionUtil());
        List versions = versionRecordServiceImpl.load(this.pathToFile);
        Assert.assertEquals((long)2L, (long)versions.size());
        Assert.assertEquals((Object)"main file", (Object)((VersionRecord)versions.get(0)).id());
        Assert.assertEquals((Object)"dot1 file", (Object)((VersionRecord)versions.get(1)).id());
    }

    @Test
    public void testNoDotFile() throws Exception {
        this.ioService.setExistingPaths(this.pathToFile);
        VersionRecordServiceImpl versionRecordServiceImpl = new VersionRecordServiceImpl((IOService)this.ioService, new VersionUtil());
        List versions = versionRecordServiceImpl.load(this.pathToFile);
        Assert.assertEquals((long)3L, (long)versions.size());
        Assert.assertEquals((Object)"id1", (Object)((VersionRecord)versions.get(0)).id());
        Assert.assertEquals((Object)"id3", (Object)((VersionRecord)versions.get(1)).id());
        Assert.assertEquals((Object)"id4", (Object)((VersionRecord)versions.get(2)).id());
    }

    @Test
    public void testLoadRecord() throws Exception {
        this.ioService.setExistingPaths(this.pathToFile);
        VersionRecordServiceImpl versionRecordServiceImpl = new VersionRecordServiceImpl((IOService)this.ioService, new VersionUtil(){

            public Path getPath(Path path, String version) throws URISyntaxException {
                return path;
            }

            public String getVersion(Path path) {
                return "id3";
            }
        });
        VersionRecord record = versionRecordServiceImpl.loadRecord(this.pathToFile);
        Assert.assertEquals((Object)record.id(), (Object)"id3");
    }

    @Test
    public void testLoadRecordMaster() throws Exception {
        this.ioService.setExistingPaths(this.pathToFile);
        VersionRecordServiceImpl versionRecordServiceImpl = new VersionRecordServiceImpl((IOService)this.ioService, new VersionUtil(){

            public Path getPath(Path path, String version) throws URISyntaxException {
                return path;
            }

            public String getVersion(Path path) {
                return "master";
            }
        });
        VersionRecord record = versionRecordServiceImpl.loadRecord(this.pathToFile);
        Assert.assertEquals((Object)record.id(), (Object)"id1");
    }

    private VersionRecord makeVersionRecord(final String id, final String uri, final Date date) {
        return new VersionRecord(){

            public String id() {
                return id;
            }

            public String author() {
                return null;
            }

            public String email() {
                return null;
            }

            public String comment() {
                return null;
            }

            public Date date() {
                return date;
            }

            public String uri() {
                return uri;
            }
        };
    }

    private class MockVersionAttributeView
    extends VersionAttributeView<Path> {
        List<VersionRecord> records;

        public MockVersionAttributeView(Path path) {
            super(path);
            this.records = VersionRecordServiceImplTest.this.pathToFile.equals(path) ? VersionRecordServiceImplTest.this.mainFileVersionRecords : VersionRecordServiceImplTest.this.dotFileVersionRecords;
        }

        public VersionAttributes readAttributes() throws IOException {
            return new VersionAttributes(){

                public VersionHistory history() {
                    return new VersionHistory(){

                        public List<VersionRecord> records() {
                            return MockVersionAttributeView.this.records;
                        }
                    };
                }

                public FileTime lastModifiedTime() {
                    return null;
                }

                public FileTime lastAccessTime() {
                    return null;
                }

                public FileTime creationTime() {
                    return null;
                }

                public boolean isRegularFile() {
                    return false;
                }

                public boolean isDirectory() {
                    return false;
                }

                public boolean isSymbolicLink() {
                    return false;
                }

                public boolean isOther() {
                    return false;
                }

                public long size() {
                    return 0L;
                }

                public Object fileKey() {
                    return null;
                }
            };
        }

        public Class[] viewTypes() {
            return new Class[0];
        }
    }
}

