/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service.htmleditor;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.backend.service.htmleditor.HtmlEditorServiceImpl;
import org.uberfire.ext.editor.commons.file.DefaultMetadata;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;

@RunWith(value=MockitoJUnitRunner.class)
public class HtmlEditorServiceImplTest {
    @Mock
    private VFSService vfsServices;
    @Mock
    private DeleteService deleteService;
    @Mock
    private RenameService renameService;
    @Mock
    private CopyService copyService;
    @Mock
    private SaveAndRenameServiceImpl<String, DefaultMetadata> saveAndRenameService;
    @Mock
    private Path path;
    @Mock
    private DefaultMetadata metadata;
    private String content = "content";
    private String comment = "comment";
    private String newFileName = "newFileName";
    @Spy
    @InjectMocks
    private HtmlEditorServiceImpl htmlEditorService;

    @Test
    public void testInit() throws Exception {
        this.htmlEditorService.init();
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameService)).init((SupportsSaveAndRename)this.htmlEditorService);
    }

    @Test
    public void testDelete() throws Exception {
        this.htmlEditorService.delete(this.path, this.comment);
        ((DeleteService)Mockito.verify((Object)this.deleteService)).delete(this.path, this.comment);
    }

    @Test
    public void testRename() throws Exception {
        Path expectedPath = (Path)Mockito.mock(Path.class);
        ((RenameService)Mockito.doReturn((Object)expectedPath).when((Object)this.renameService)).rename(this.path, this.newFileName, this.comment);
        Path actualPath = this.htmlEditorService.rename(this.path, this.newFileName, this.comment);
        ((RenameService)Mockito.verify((Object)this.renameService)).rename(this.path, this.newFileName, this.comment);
        Assert.assertEquals((Object)expectedPath, (Object)actualPath);
    }

    @Test
    public void testSave() throws Exception {
        Path expectedPath = (Path)Mockito.mock(Path.class);
        ((VFSService)Mockito.doReturn((Object)expectedPath).when((Object)this.vfsServices)).write(this.path, this.content);
        Path actualPath = this.htmlEditorService.save(this.path, this.content, this.metadata, this.comment);
        ((VFSService)Mockito.verify((Object)this.vfsServices)).write(this.path, this.content);
        Assert.assertEquals((Object)expectedPath, (Object)actualPath);
    }

    @Test
    public void testCopyWithoutTargetDirectory() throws Exception {
        Path expectedPath = (Path)Mockito.mock(Path.class);
        ((CopyService)Mockito.doReturn((Object)expectedPath).when((Object)this.copyService)).copy(this.path, this.newFileName, this.comment);
        Path actualPath = this.htmlEditorService.copy(this.path, this.newFileName, this.comment);
        ((CopyService)Mockito.verify((Object)this.copyService)).copy(this.path, this.newFileName, this.comment);
        Assert.assertEquals((Object)expectedPath, (Object)actualPath);
    }

    @Test
    public void testCopyWithTargetDirectory() throws Exception {
        Path targetDirectory = (Path)Mockito.mock(Path.class);
        Path expectedPath = (Path)Mockito.mock(Path.class);
        ((CopyService)Mockito.doReturn((Object)expectedPath).when((Object)this.copyService)).copy(this.path, this.newFileName, targetDirectory, this.comment);
        Path actualPath = this.htmlEditorService.copy(this.path, this.newFileName, targetDirectory, this.comment);
        ((CopyService)Mockito.verify((Object)this.copyService)).copy(this.path, this.newFileName, targetDirectory, this.comment);
        Assert.assertEquals((Object)expectedPath, (Object)actualPath);
    }

    @Test
    public void testLoad() throws Exception {
        String expectedString = "string";
        ((VFSService)Mockito.doReturn((Object)"string").when((Object)this.vfsServices)).readAllString(this.path);
        String actualString = this.htmlEditorService.load(this.path);
        ((VFSService)Mockito.verify((Object)this.vfsServices)).readAllString(this.path);
        Assert.assertEquals((Object)"string", (Object)actualString);
    }

    @Test
    public void testSaveAndRename() throws Exception {
        Path expectedPath = (Path)Mockito.mock(Path.class);
        ((SaveAndRenameServiceImpl)Mockito.doReturn((Object)expectedPath).when(this.saveAndRenameService)).saveAndRename(this.path, this.newFileName, (Object)this.metadata, (Object)this.content, this.comment);
        Path actualPath = this.htmlEditorService.saveAndRename(this.path, this.newFileName, this.metadata, this.content, this.comment);
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameService)).saveAndRename(this.path, this.newFileName, (Object)this.metadata, (Object)this.content, this.comment);
        Assert.assertEquals((Object)expectedPath, (Object)actualPath);
    }
}

