/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service.naming;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.backend.service.naming.PathNamingServiceImpl;
import org.uberfire.ext.editor.commons.service.PathNamingService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.FileSystemTestingUtils;
import org.uberfire.workbench.category.Category;
import org.uberfire.workbench.category.Others;
import org.uberfire.workbench.type.ResourceTypeDefinition;

public class PathNamingServiceImplTest {
    private static final String PATH_PREFIX = "git://amend-repo-test/";
    private static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    private PathNamingService pathNamingService;
    private Collection<ResourceTypeDefinition> resourceTypeDefinitions;

    @Before
    public void setup() throws IOException {
        fileSystemTestingUtils.setup();
        this.resourceTypeDefinitions = this.createResourceTypeDefinitions();
        this.pathNamingService = this.createPathNamingService();
    }

    @After
    public void cleanupFileSystem() {
        fileSystemTestingUtils.cleanup();
    }

    @Test
    public void buildTargetPathForFolderInTheSameDirectoryTest() {
        Assert.assertEquals((Object)"newFolderName", (Object)this.targetFolderName("originalFolderName", "newFolderName"));
        Assert.assertEquals((Object)"newFolderName", (Object)this.targetFolderName("original.folder.name", "newFolderName"));
        Assert.assertEquals((Object)"newFolderName", (Object)this.targetFolderName("originalFolder.name", "newFolderName"));
        Assert.assertEquals((Object)"new.folder.name", (Object)this.targetFolderName("originalFolderName", "new.folder.name"));
        Assert.assertEquals((Object)"new.folder.name", (Object)this.targetFolderName("original.folder.name", "new.folder.name"));
        Assert.assertEquals((Object)"new.folder.name", (Object)this.targetFolderName("originalFolder.name", "new.folder.name"));
        Assert.assertEquals((Object)"newFolder.name", (Object)this.targetFolderName("originalFolderName", "newFolder.name"));
        Assert.assertEquals((Object)"newFolder.name", (Object)this.targetFolderName("original.folder.name", "newFolder.name"));
        Assert.assertEquals((Object)"newFolder.name", (Object)this.targetFolderName("originalFolder.name", "newFolder.name"));
    }

    @Test
    public void buildTargetPathForFileInTheSameDirectoryTest() {
        Assert.assertEquals((Object)"newFileName", (Object)this.targetFileName("originalFileName", "newFileName"));
        Assert.assertEquals((Object)"newFileName.extension2", (Object)this.targetFileName("originalFileName.extension1.extension2", "newFileName"));
        Assert.assertEquals((Object)"newFileName.extension", (Object)this.targetFileName("originalFileName.extension", "newFileName"));
        Assert.assertEquals((Object)"newFileName.extension1.extension2", (Object)this.targetFileName("originalFileName", "newFileName.extension1.extension2"));
        Assert.assertEquals((Object)"newFileName.extension1.extension2.extension2", (Object)this.targetFileName("originalFileName.extension1.extension2", "newFileName.extension1.extension2"));
        Assert.assertEquals((Object)"newFileName.extension1.extension2.extension", (Object)this.targetFileName("originalFileName.extension", "newFileName.extension1.extension2"));
        Assert.assertEquals((Object)"newFileName.extension", (Object)this.targetFileName("originalFileName", "newFileName.extension"));
        Assert.assertEquals((Object)"newFileName.extension.extension2", (Object)this.targetFileName("originalFileName.extension1.extension2", "newFileName.extension"));
        Assert.assertEquals((Object)"newFileName.extension.extension", (Object)this.targetFileName("originalFileName.extension", "newFileName.extension"));
    }

    @Test
    public void buildTargetPathForResourceTypeFileInTheSameDirectoryTest() {
        Assert.assertEquals((Object)"newFileName.resource", (Object)this.targetFileName("originalFileName.resource", "newFileName"));
        Assert.assertEquals((Object)"newFileName.resource.xml", (Object)this.targetFileName("originalFileName.resource.xml", "newFileName"));
        Assert.assertEquals((Object)"newFileName.resource.xml.txt", (Object)this.targetFileName("originalFileName.resource.xml.txt", "newFileName"));
    }

    @Test
    public void buildTargetPathForFolderInAnotherDirectoryTest() {
        org.uberfire.backend.vfs.Path originalPath = this.createFolder("parent/folder");
        org.uberfire.backend.vfs.Path targetParentDirectory = this.createFolder("new-parent");
        String targetFileName = "new-folder";
        org.uberfire.backend.vfs.Path targetPath = this.pathNamingService.buildTargetPath(originalPath, targetParentDirectory, targetFileName);
        Assert.assertEquals((Object)(targetParentDirectory.toURI() + "/" + targetFileName), (Object)targetPath.toURI());
    }

    @Test
    public void buildTargetPathForFileInAnotherDirectoryTest() {
        String extension = ".txt";
        org.uberfire.backend.vfs.Path originalPath = this.createFile("parent/file" + extension);
        org.uberfire.backend.vfs.Path targetParentDirectory = this.createFolder("new-parent");
        String targetFileName = "new-file";
        org.uberfire.backend.vfs.Path targetPath = this.pathNamingService.buildTargetPath(originalPath, targetParentDirectory, targetFileName);
        Assert.assertEquals((Object)(targetParentDirectory.toURI() + "/" + targetFileName + extension), (Object)targetPath.toURI());
    }

    @Test
    public void buildTargetPathForResourceTypeFileInAnotherDirectoryTest() {
        String extension = ".resource.xml.txt";
        org.uberfire.backend.vfs.Path originalPath = this.createFile("parent/resource-file" + extension);
        org.uberfire.backend.vfs.Path targetParentDirectory = this.createFolder("new-parent");
        String targetFileName = "new-resource-file";
        org.uberfire.backend.vfs.Path targetPath = this.pathNamingService.buildTargetPath(originalPath, targetParentDirectory, targetFileName);
        Assert.assertEquals((Object)(targetParentDirectory.toURI() + "/" + targetFileName + extension), (Object)targetPath.toURI());
    }

    private org.uberfire.backend.vfs.Path createFolder(String folderName) {
        return Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)PathFactory.newPath((String)"file", (String)(PATH_PREFIX + folderName + "/file"))).getParent());
    }

    private org.uberfire.backend.vfs.Path createFile(String fileName) {
        return PathFactory.newPath((String)fileName, (String)(PATH_PREFIX + fileName));
    }

    private String targetFolderName(String originalFolderName, String newFolderName) {
        org.uberfire.backend.vfs.Path path = PathFactory.newPath((String)"file", (String)(PATH_PREFIX + originalFolderName + "/file"));
        fileSystemTestingUtils.getIoService().write(Paths.convert((org.uberfire.backend.vfs.Path)path), "content", new OpenOption[0]);
        return this.pathNamingService.buildTargetPath(Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)path).getParent()), newFolderName).getFileName();
    }

    private String targetFileName(String originalFileName, String newFileName) {
        org.uberfire.backend.vfs.Path path = PathFactory.newPath((String)originalFileName, (String)(PATH_PREFIX + originalFileName));
        fileSystemTestingUtils.getIoService().write(Paths.convert((org.uberfire.backend.vfs.Path)path), "content", new OpenOption[0]);
        return this.pathNamingService.buildTargetPath(path, newFileName).getFileName();
    }

    private PathNamingService createPathNamingService() {
        return new PathNamingServiceImpl(){

            public Iterable<ResourceTypeDefinition> getResourceTypeDefinitions() {
                return PathNamingServiceImplTest.this.resourceTypeDefinitions;
            }
        };
    }

    private Collection<ResourceTypeDefinition> createResourceTypeDefinitions() {
        ArrayList<ResourceTypeDefinition> resourceTypeDefinitions = new ArrayList<ResourceTypeDefinition>();
        resourceTypeDefinitions.add(this.createResourceTypeDefinition("resource"));
        resourceTypeDefinitions.add(this.createResourceTypeDefinition("resource.xml"));
        resourceTypeDefinitions.add(this.createResourceTypeDefinition("resource.xml.txt"));
        return resourceTypeDefinitions;
    }

    private ResourceTypeDefinition createResourceTypeDefinition(final String suffix) {
        return new ResourceTypeDefinition(){

            public String getShortName() {
                return null;
            }

            public String getDescription() {
                return null;
            }

            public String getPrefix() {
                return null;
            }

            public String getSuffix() {
                return suffix;
            }

            public int getPriority() {
                return 0;
            }

            public String getSimpleWildcardPattern() {
                return null;
            }

            public boolean accept(org.uberfire.backend.vfs.Path path) {
                return false;
            }

            public Category getCategory() {
                return new Others();
            }
        };
    }
}

