/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.enterprise.inject.Instance;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.ArtifactImpl;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.m2repo.backend.server.M2RepoServiceImpl;
import org.guvnor.m2repo.backend.server.helpers.FormData;
import org.guvnor.m2repo.backend.server.helpers.HttpPostHelper;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepository;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepositoryProducer;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepositoryService;
import org.guvnor.m2repo.model.JarListPageRequest;
import org.guvnor.m2repo.model.JarListPageRow;
import org.guvnor.m2repo.preferences.ArtifactRepositoryPreference;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.cdi.workspace.WorkspaceNameResolver;
import org.uberfire.mocks.MockInstanceImpl;
import org.uberfire.paging.PageResponse;

public class M2RepositoryServiceImplTest {
    private static final Logger log = LoggerFactory.getLogger(M2RepositoryServiceImplTest.class);
    private static GAV gavBackend;
    private static GAV gavBackend1;
    private static GAV gavBackend2;
    private static GAV gavArquillian;
    private GuvnorM2Repository repo;
    private M2RepoServiceImpl service;
    private HttpPostHelper helper;
    private Method helperMethod;
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @BeforeClass
    public static void setupClass() {
        gavBackend = new GAV("org.kie.guvnor", "guvnor-m2repo-editor-backend", "0.0.1-SNAPSHOT");
        gavBackend1 = new GAV("org.kie.guvnor", "guvnor-m2repo-editor-backend1", "0.0.1-SNAPSHOT");
        gavBackend2 = new GAV("org.kie.guvnor", "guvnor-m2repo-editor-backend2", "0.0.1-SNAPSHOT");
        gavArquillian = new GAV("org.jboss.arquillian.core", "arquillian-core-api", "1.0.2.Final");
    }

    @Before
    public void setup() throws Exception {
        log.info("Deleting existing Repositories instance..");
        File dir = new File("repositories");
        log.info("DELETING test repo: " + dir.getAbsolutePath());
        M2RepositoryServiceImplTest.deleteDir(dir);
        log.info("TEST repo was deleted.");
        ArtifactRepositoryPreference pref = (ArtifactRepositoryPreference)Mockito.mock(ArtifactRepositoryPreference.class);
        Mockito.when((Object)pref.getGlobalM2RepoDir()).thenReturn((Object)"repositories/kie");
        Mockito.when((Object)pref.isGlobalM2RepoDirEnabled()).thenReturn((Object)true);
        Mockito.when((Object)pref.isDistributionManagementM2RepoDirEnabled()).thenReturn((Object)true);
        Mockito.when((Object)pref.isWorkspaceM2RepoDirEnabled()).thenReturn((Object)false);
        WorkspaceNameResolver resolver = (WorkspaceNameResolver)Mockito.mock(WorkspaceNameResolver.class);
        Mockito.when((Object)resolver.getWorkspaceName()).thenReturn((Object)"global");
        ArtifactRepositoryProducer producer = new ArtifactRepositoryProducer(pref, resolver);
        producer.initialize();
        MockInstanceImpl repositories = new MockInstanceImpl((Object[])new ArtifactRepository[]{producer.produceLocalRepository(), producer.produceGlobalRepository(), producer.produceDistributionManagementRepository()});
        ArtifactRepositoryService factory = new ArtifactRepositoryService((Instance)repositories);
        this.repo = new GuvnorM2Repository(factory);
        this.repo.init();
        this.service = new M2RepoServiceImpl(this.repo);
        Field repositoryField = M2RepoServiceImpl.class.getDeclaredField("repository");
        repositoryField.setAccessible(true);
        repositoryField.set(this.service, this.repo);
        this.helper = new HttpPostHelper();
        this.helperMethod = HttpPostHelper.class.getDeclaredMethod("upload", FormData.class);
        this.helperMethod.setAccessible(true);
        Field m2RepoServiceField = HttpPostHelper.class.getDeclaredField("m2RepoService");
        m2RepoServiceField.setAccessible(true);
        m2RepoServiceField.set(this.helper, this.service);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        log.info("Deleting all Repository instances..");
        File dir = new File("repositories");
        log.info("DELETING test repo: " + dir.getAbsolutePath());
        M2RepositoryServiceImplTest.deleteDir(dir);
        log.info("TEST repo was deleted.");
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                if (M2RepositoryServiceImplTest.deleteDir(new File(dir, children[i]))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    @Test
    public void testDeployArtifact() throws Exception {
        this.deployArtifact(gavBackend);
        Collection files = this.repo.listFiles();
        boolean found = false;
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.startsWith("guvnor-m2repo-editor-backend-0.0.1") || !fileName.endsWith(".jar")) continue;
            found = true;
            String path = file.getPath();
            String jarPath = path.substring(this.repo.getM2RepositoryRootDir("global-m2-repo").length());
            String pom = this.repo.getPomText(jarPath);
            Assert.assertNotNull((Object)pom);
            break;
        }
        Assert.assertTrue((String)"Did not find expected file after calling M2Repository.addFile()", (boolean)found);
        File file = this.repo.getArtifactFileFromRepository(gavBackend);
        Assert.assertNotNull((String)"Empty file for artifact", (Object)file);
        JarFile jarFile = new JarFile(file);
        int count = 0;
        Object lastEntryName = null;
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            ++count;
            JarEntry entry = entries.nextElement();
            Assert.assertNotEquals((String)"Endless loop.", lastEntryName, (Object)entry.getName());
        }
        Assert.assertTrue((String)"Empty jar file!", (count > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDeployPom() throws Exception {
        InputStream is = this.getClass().getResourceAsStream("guvnor-m2repo-editor-backend-test-pom.xml");
        this.repo.deployPom(is, gavBackend);
        Collection files = this.repo.listFiles();
        boolean found = false;
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.startsWith("guvnor-m2repo-editor-backend-0.0.1") || !fileName.endsWith(".pom")) continue;
            found = true;
            String path = file.getPath();
            String jarPath = path.substring(this.repo.getM2RepositoryRootDir("global-m2-repo").length());
            String pom = this.repo.getPomText(jarPath);
            Assert.assertNotNull((Object)pom);
            break;
        }
        Assert.assertTrue((String)"Did not find expected file after calling M2Repository.addFile()", (boolean)found);
    }

    @Test
    public void testListFiles() throws Exception {
        this.deployArtifact(gavBackend);
        this.deployArtifact(gavArquillian);
        Collection files = this.repo.listFiles();
        boolean found1 = false;
        boolean found2 = false;
        for (File file : files) {
            String fileName = file.getName();
            if (fileName.startsWith("guvnor-m2repo-editor-backend-0.0.1") && fileName.endsWith(".jar")) {
                found1 = true;
            }
            if (!fileName.startsWith("arquillian-core-api-1.0.2.Final") || !fileName.endsWith(".jar")) continue;
            found2 = true;
        }
        Assert.assertTrue((String)"Did not find expected file after calling M2Repository.addFile()", (boolean)found1);
        Assert.assertTrue((String)"Did not find expected file after calling M2Repository.addFile()", (boolean)found2);
    }

    @Test
    public void testListFilesWithFilter() throws Exception {
        String fileName;
        String fileName2;
        this.deployArtifact(gavBackend);
        this.deployArtifact(gavArquillian);
        boolean found1 = false;
        List files = this.repo.listFiles("1.0.2");
        String VERSION_NUMBER_SEARCH_FILTER = "arquillian-core-api-1.0.2";
        for (File file : files) {
            fileName2 = file.getName();
            if (!fileName2.startsWith("arquillian-core-api-1.0.2") || !fileName2.endsWith(".jar")) continue;
            found1 = true;
        }
        Assert.assertTrue((String)"Did not find expected file after calling M2Repository.addFile()", (boolean)found1);
        for (File file : files) {
            fileName2 = file.getName();
            if (fileName2.contains("arquillian-core-api-1.0.2")) continue;
            Assert.fail((String)(fileName2 + " doesn't match the filter " + "arquillian-core-api-1.0.2"));
        }
        found1 = false;
        files = this.repo.listFiles("arquillian-core-api");
        String ARTIFACT_SEARCH_FILTER = "arquillian-core-api";
        for (File file : files) {
            fileName = file.getName();
            if (!fileName.startsWith("arquillian-core-api") || !fileName.endsWith(".jar")) continue;
            found1 = true;
        }
        Assert.assertTrue((String)"Did not find expected file after calling M2Repository.addFile()", (boolean)found1);
        for (File file : files) {
            fileName = file.getName();
            if (fileName.contains("arquillian-core-api")) continue;
            Assert.fail((String)(fileName + " doesn't match the filter " + "arquillian-core-api"));
        }
    }

    @Test
    public void testUploadJARWithPOM() throws Exception {
        FormData uploadItem = new FormData();
        MockFileItem file = new MockFileItem("guvnor-m2repo-editor-backend-test-with-pom.jar", this.getClass().getResourceAsStream("guvnor-m2repo-editor-backend-test-with-pom.jar"));
        uploadItem.setFile((FileItem)file);
        assert (this.helperMethod.invoke((Object)this.helper, uploadItem).equals("OK"));
    }

    @Test
    public void testUploadKJARWithPOM() throws Exception {
        FormData uploadItem = new FormData();
        MockFileItem file = new MockFileItem("guvnor-m2repo-editor-backend-test-with-pom.kjar", this.getClass().getResourceAsStream("guvnor-m2repo-editor-backend-test-with-pom.jar"));
        uploadItem.setFile((FileItem)file);
        assert (this.helperMethod.invoke((Object)this.helper, uploadItem).equals("OK"));
    }

    @Test
    public void testUploadJARWithManualGAV() throws Exception {
        FormData uploadItem = new FormData();
        uploadItem.setGav(gavBackend);
        MockFileItem file = new MockFileItem("guvnor-m2repo-editor-backend-test-without-pom.jar", this.getClass().getResourceAsStream("guvnor-m2repo-editor-backend-test-without-pom.jar"));
        uploadItem.setFile((FileItem)file);
        assert (this.helperMethod.invoke((Object)this.helper, uploadItem).equals("OK"));
    }

    @Test
    public void testUploadKJARWithManualGAV() throws Exception {
        FormData uploadItem = new FormData();
        uploadItem.setGav(gavBackend);
        MockFileItem file = new MockFileItem("guvnor-m2repo-editor-backend-test.kjar", this.getClass().getResourceAsStream("guvnor-m2repo-editor-backend-test-without-pom.jar"));
        uploadItem.setFile((FileItem)file);
        assert (this.helperMethod.invoke((Object)this.helper, uploadItem).equals("OK"));
    }

    @Test
    public void testListArtifacts() throws Exception {
        ArrayList<ArtifactImpl> artifacts = new ArrayList<ArtifactImpl>();
        int TOTAL = 5;
        boolean PAGE_START = true;
        int PAGE_SIZE = 2;
        for (int i = 0; i < 5; ++i) {
            ArtifactImpl artifact = new ArtifactImpl(new File(this.repo.getM2RepositoryRootDir("global-m2-repo"), "path/x" + i));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("repository", "guvnor-m2-repo");
            artifact.setProperties(map);
            artifacts.add(artifact);
        }
        GuvnorM2Repository mockRepo = (GuvnorM2Repository)Mockito.mock(GuvnorM2Repository.class);
        Mockito.when((Object)mockRepo.listArtifacts(Mockito.anyString(), (List)Matchers.any())).thenReturn(artifacts);
        Mockito.when((Object)mockRepo.getM2RepositoryDir((String)Mockito.any())).thenReturn((Object)this.repo.getM2RepositoryDir("global-m2-repo"));
        M2RepoServiceImpl m2service = new M2RepoServiceImpl(mockRepo);
        JarListPageRequest request = new JarListPageRequest(1, Integer.valueOf(2), null, null, null, false);
        PageResponse response = m2service.listArtifacts(request);
        Assert.assertEquals((long)2L, (long)response.getPageRowList().size());
        Assert.assertEquals((long)5L, (long)response.getTotalRowSize());
        int i = 1;
        for (JarListPageRow row : response.getPageRowList()) {
            Assert.assertEquals((Object)("x" + i), (Object)row.getName());
            Assert.assertEquals((Object)("path/x" + i), (Object)row.getPath());
            ++i;
        }
    }

    @Test
    public void testUploadPOM() throws Exception {
        FormData uploadItem = new FormData();
        MockFileItem file = new MockFileItem("pom.xml", this.getClass().getResourceAsStream("guvnor-m2repo-editor-backend-test-pom.xml"));
        uploadItem.setFile((FileItem)file);
        assert (this.helperMethod.invoke((Object)this.helper, uploadItem).equals("OK"));
        this.assertFilesCount(null, null, null, false, 1);
    }

    @Test
    public void testListFilesWithSortOnNameAscending() throws Exception {
        this.deployArtifact(gavBackend1);
        this.deployArtifact(gavBackend2);
        PageResponse<JarListPageRow> response = this.assertFilesCount(null, null, "org.guvnor.m2repo.model.name", true, 4);
        List files = response.getPageRowList();
        String fileName0 = ((JarListPageRow)files.get(0)).getName();
        String fileName2 = ((JarListPageRow)files.get(2)).getName();
        Assert.assertTrue((boolean)fileName0.startsWith("guvnor-m2repo-editor-backend1"));
        Assert.assertTrue((boolean)fileName2.startsWith("guvnor-m2repo-editor-backend2"));
    }

    @Test
    public void testListFilesWithSortOnNameDescending() throws Exception {
        this.deployArtifact(gavBackend1);
        this.deployArtifact(gavBackend2);
        PageResponse<JarListPageRow> response = this.assertFilesCount(null, null, "org.guvnor.m2repo.model.name", false, 4);
        List files = response.getPageRowList();
        String fileName0 = ((JarListPageRow)files.get(0)).getName();
        String fileName2 = ((JarListPageRow)files.get(2)).getName();
        Assert.assertTrue((boolean)fileName0.startsWith("guvnor-m2repo-editor-backend2"));
        Assert.assertTrue((boolean)fileName2.startsWith("guvnor-m2repo-editor-backend1"));
    }

    @Test
    public void testListFilesWithSortOnPathAscending() throws Exception {
        this.deployArtifact(gavBackend1);
        this.deployArtifact(gavBackend2);
        PageResponse<JarListPageRow> response = this.assertFilesCount(null, null, "org.guvnor.m2repo.model.path", true, 4);
        List files = response.getPageRowList();
        String filePath0 = ((JarListPageRow)files.get(0)).getPath();
        String filePath2 = ((JarListPageRow)files.get(2)).getPath();
        Assert.assertTrue((boolean)filePath0.contains("guvnor-m2repo-editor-backend1"));
        Assert.assertTrue((boolean)filePath2.contains("guvnor-m2repo-editor-backend2"));
    }

    @Test
    public void testListFilesWithSortOnPathDescending() throws Exception {
        this.deployArtifact(gavBackend1);
        this.deployArtifact(gavBackend2);
        PageResponse<JarListPageRow> response = this.assertFilesCount(null, null, "org.guvnor.m2repo.model.path", false, 4);
        List files = response.getPageRowList();
        String filePath0 = ((JarListPageRow)files.get(0)).getPath();
        String filePath2 = ((JarListPageRow)files.get(2)).getPath();
        Assert.assertTrue((boolean)filePath0.contains("guvnor-m2repo-editor-backend2"));
        Assert.assertTrue((boolean)filePath2.contains("guvnor-m2repo-editor-backend1"));
    }

    @Test
    public void testListFilesWithSortOnGavAscending() throws Exception {
        this.deployArtifact(gavBackend1);
        this.deployArtifact(gavBackend2);
        PageResponse<JarListPageRow> response = this.assertFilesCount(null, null, "org.guvnor.m2repo.model.gav", true, 4);
        List files = response.getPageRowList();
        GAV gav0 = ((JarListPageRow)files.get(0)).getGav();
        GAV gav2 = ((JarListPageRow)files.get(2)).getGav();
        Assert.assertEquals((Object)"guvnor-m2repo-editor-backend1", (Object)gav0.getArtifactId());
        Assert.assertEquals((Object)"guvnor-m2repo-editor-backend2", (Object)gav2.getArtifactId());
    }

    @Test
    public void testListFilesWithSortOnGavDescending() throws Exception {
        this.deployArtifact(gavBackend1);
        this.deployArtifact(gavBackend2);
        PageResponse<JarListPageRow> response = this.assertFilesCount(null, null, "org.guvnor.m2repo.model.gav", false, 4);
        List files = response.getPageRowList();
        GAV gav0 = ((JarListPageRow)files.get(0)).getGav();
        GAV gav2 = ((JarListPageRow)files.get(2)).getGav();
        Assert.assertEquals((Object)"guvnor-m2repo-editor-backend2", (Object)gav0.getArtifactId());
        Assert.assertEquals((Object)"guvnor-m2repo-editor-backend1", (Object)gav2.getArtifactId());
    }

    @Test
    public void testListFilesWithSortOnLastModifiedAscending() throws Exception {
        this.deployArtifact(gavBackend1);
        Thread.sleep(2000L);
        this.deployArtifact(gavBackend2);
        PageResponse<JarListPageRow> response = this.assertFilesCount(null, null, "org.guvnor.m2repo.model.last.modified", true, 4);
        List files = response.getPageRowList();
        Long fileTime0 = ((JarListPageRow)files.get(0)).getLastModified().getTime();
        Long fileTime2 = ((JarListPageRow)files.get(2)).getLastModified().getTime();
        Assert.assertTrue((fileTime0.compareTo(fileTime2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testListFilesWithSortOnLastModifiedDescending() throws Exception {
        this.deployArtifact(gavBackend1);
        Thread.sleep(2000L);
        this.deployArtifact(gavBackend2);
        PageResponse<JarListPageRow> response = this.assertFilesCount(null, null, "org.guvnor.m2repo.model.last.modified", false, 4);
        List files = response.getPageRowList();
        Long fileTime0 = ((JarListPageRow)files.get(0)).getLastModified().getTime();
        Long fileTime2 = ((JarListPageRow)files.get(2)).getLastModified().getTime();
        Assert.assertTrue((fileTime0.compareTo(fileTime2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testListFilesIncludingPom() throws Exception {
        this.deployArtifact(gavBackend);
        GAV gavBackendParent = new GAV("org.kie.guvnor", "guvnor-m2repo-editor-backend-parent", "0.0.1-SNAPSHOT");
        InputStream is = this.getClass().getResourceAsStream("guvnor-m2repo-editor-backend-test-pom.xml");
        this.repo.deployPom(is, gavBackendParent);
        this.assertFilesCount(null, null, null, false, 3);
    }

    @Test
    public void testListFilesWhenNoneExist() throws Exception {
        this.assertFilesCount(null, null, "org.guvnor.m2repo.model.gav", false, 0);
    }

    @Test
    public void testListFilesWithPageSize() throws Exception {
        this.deployArtifact(gavBackend1);
        this.deployArtifact(gavBackend2);
        JarListPageRequest request = new JarListPageRequest(0, Integer.valueOf(10), null, null, null, true);
        PageResponse response = this.service.listArtifacts(request);
        Assert.assertEquals((long)4L, (long)response.getPageRowList().size());
    }

    @Test
    public void testListFilesWithStartBeyondMaximum() throws Exception {
        this.deployArtifact(gavBackend1);
        this.deployArtifact(gavBackend2);
        JarListPageRequest request = new JarListPageRequest(10, Integer.valueOf(10), null, null, null, true);
        PageResponse response = this.service.listArtifacts(request);
        Assert.assertEquals((long)0L, (long)response.getPageRowList().size());
    }

    @Test
    public void testCheckArtifactExistsReturnsTrueForExistingArtifact() {
        this.deployArtifact(gavBackend);
        Assert.assertTrue((boolean)this.repo.containsArtifact(gavBackend));
    }

    @Test
    public void testCheckArtifactExistsReturnsFalseForNonExistingArtifact() {
        Assert.assertFalse((boolean)this.repo.containsArtifact(new GAV("org.guvnor:non-existing-jar:1.0.Final")));
    }

    @Test
    public void testGetPomTextRejectsTraversingPaths() {
        this.service.getPomText("dir/name.jar");
        this.service.getPomText("dir/name.kjar");
        this.service.getPomText("dir/name.pom");
        this.exception.expect(RuntimeException.class);
        this.service.getPomText("path/../file.pom");
    }

    @Test
    public void testLoadGAVFromJarRejectsTraversingPaths() {
        this.exception.expect(RuntimeException.class);
        this.service.loadGAVFromJar("path/../file.jar");
    }

    private PageResponse<JarListPageRow> assertFilesCount(String filters, List<String> fileFormats, String dataSourceName, boolean isAscending, int filesCount) {
        JarListPageRequest request = new JarListPageRequest(0, null, filters, fileFormats, dataSourceName, isAscending);
        PageResponse response = this.service.listArtifacts(request);
        Assert.assertEquals((long)filesCount, (long)response.getPageRowList().size());
        return response;
    }

    private void deployArtifact(GAV gav) {
        InputStream is = this.getClass().getResourceAsStream("guvnor-m2repo-editor-backend-test-without-pom.jar");
        this.repo.deployArtifact(is, gav, false);
    }

    class MockFileItem
    implements FileItem {
        private final String fileName;
        private final InputStream fileStream;

        MockFileItem(String fileName, InputStream fileStream) {
            this.fileName = fileName;
            this.fileStream = fileStream;
        }

        public InputStream getInputStream() throws IOException {
            return this.fileStream;
        }

        public String getContentType() {
            return null;
        }

        public String getName() {
            return this.fileName;
        }

        public boolean isInMemory() {
            return false;
        }

        public long getSize() {
            return 0L;
        }

        public byte[] get() {
            return null;
        }

        public String getString(String encoding) throws UnsupportedEncodingException {
            return null;
        }

        public String getString() {
            return null;
        }

        public void write(File file) throws Exception {
        }

        public void delete() {
        }

        public String getFieldName() {
            return null;
        }

        public void setFieldName(String name) {
        }

        public boolean isFormField() {
            return false;
        }

        public void setFormField(boolean state) {
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public FileItemHeaders getHeaders() {
            return null;
        }

        public void setHeaders(FileItemHeaders fileItemHeaders) {
        }
    }
}

