/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.apache.commons.fileupload.FileItem;
import org.appformer.maven.support.PomModel;
import org.guvnor.m2repo.backend.server.M2RepoServiceCreator;
import org.guvnor.m2repo.backend.server.MockFileItem;
import org.guvnor.m2repo.backend.server.helpers.FormData;
import org.guvnor.m2repo.backend.server.helpers.HttpPostHelper;
import org.guvnor.m2repo.backend.server.helpers.PomModelResolver;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GAVResolverFromParentPomTest {
    private static final Logger log = LoggerFactory.getLogger(GAVResolverFromParentPomTest.class);
    private static final String PARENT_POM = "parent-gav-pom.xml";

    @AfterClass
    public static void tearDown() {
        log.info("Deleting all Repository instances..");
        File dir = new File("repositories");
        log.info("DELETING test repo: " + dir.getAbsolutePath());
        M2RepoServiceCreator.deleteDir(dir);
        log.info("TEST repo was deleted.");
    }

    @Before
    public void setup() throws Exception {
        M2RepoServiceCreator m2RepoServiceCreator = new M2RepoServiceCreator();
        HttpPostHelper helper = m2RepoServiceCreator.getHelper();
        Method helperMethod = m2RepoServiceCreator.getHelperMethod();
        FormData uploadItem = new FormData();
        MockFileItem file = new MockFileItem("pom.xml", this.getClass().getResourceAsStream(PARENT_POM));
        uploadItem.setFile((FileItem)file);
        TestCase.assertEquals((String)"Error occurred when uploading pom", (Object)"OK", (Object)helperMethod.invoke((Object)helper, uploadItem));
    }

    @Test
    public void testResolveGavFromParentPomOnlyGroupID() throws Exception {
        String pathToPomWithoutVersion = "org/guvnor/m2repo/backend/server/helpers/gav-pom-without-version.xml";
        PomModel pomModel = this.resolvePom(pathToPomWithoutVersion);
        TestCase.assertEquals((String)"The groupID does not match to child pom", (String)"org.guvnor.m2repo.backend.server.helpers", (String)pomModel.getReleaseId().getGroupId());
        TestCase.assertEquals((String)"The version does not match to parent pom", (String)"1.0", (String)pomModel.getReleaseId().getVersion());
    }

    @Test
    public void testResolveGavFromParentPomOnlyVersion() throws Exception {
        String pathToPomWithoutGroup = "org/guvnor/m2repo/backend/server/helpers/gav-pom-without-group.xml";
        PomModel pomModel = this.resolvePom(pathToPomWithoutGroup);
        TestCase.assertEquals((String)"The groupID does not match to parent pom", (String)"org.guvnor.test", (String)pomModel.getReleaseId().getGroupId());
        TestCase.assertEquals((String)"The version does not match to child pom", (String)"1.1.1", (String)pomModel.getReleaseId().getVersion());
    }

    private PomModel resolvePom(String path) throws Exception {
        InputStream pomInputStream = this.getClass().getClassLoader().getResourceAsStream(path);
        return PomModelResolver.resolveFromPom((InputStream)pomInputStream);
    }
}

