/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.elastic.index;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.lucene.analysis.Analyzer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.ext.metadata.backend.elastic.index.ElasticSearchIndexProvider;
import org.uberfire.ext.metadata.backend.elastic.metamodel.ElasticMetaProperty;
import org.uberfire.ext.metadata.backend.elastic.provider.ElasticSearchContext;
import org.uberfire.ext.metadata.engine.MetaModelStore;
import org.uberfire.ext.metadata.metamodel.NullMetaModelStore;
import org.uberfire.ext.metadata.model.schema.MetaProperty;

public class ElasticSearchIndexProviderTest {
    private ElasticSearchIndexProvider provider;

    @Before
    public void setUp() {
        this.provider = new ElasticSearchIndexProvider((MetaModelStore)new NullMetaModelStore(), (ElasticSearchContext)Mockito.mock(ElasticSearchContext.class), (Analyzer)Mockito.mock(Analyzer.class));
    }

    @Test
    public void testEscapeSpecialCharacters() {
        String expected = "(+field:value AND +field2:\\+AAA123=) OR url:git\\:\\/\\/master@path\\/to\\/file";
        String queryString = "(+field:value AND +field2:+AAA123=) OR url:git://master@path/to/file";
        String escapedQueryString = this.provider.escapeSpecialCharacters(queryString);
        Assert.assertEquals((Object)expected, (Object)escapedQueryString);
    }

    @Test
    public void testCreateElasticTypeKeyword() {
        ElasticMetaProperty metaProperty = new ElasticMetaProperty("field", "value", new HashSet<Class>(Arrays.asList(String.class)));
        String type = this.provider.createElasticType((MetaProperty)metaProperty);
        Assert.assertEquals((Object)"keyword", (Object)type);
    }

    @Test
    public void testCreateElasticTypeText() {
        ElasticMetaProperty metaProperty = new ElasticMetaProperty("field", "value", new HashSet<Class>(Arrays.asList(String.class)), false, true);
        String type = this.provider.createElasticType((MetaProperty)metaProperty);
        Assert.assertEquals((Object)"text", (Object)type);
    }

    @Test
    public void testCreateElasticTypeOther() {
        ElasticMetaProperty metaProperty = new ElasticMetaProperty("field", "1", new HashSet<Class>(Arrays.asList(Integer.class)), false, true);
        String type = this.provider.createElasticType((MetaProperty)metaProperty);
        Assert.assertEquals((Object)"integer", (Object)type);
    }
}

