/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.elastic.metamodel;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.uberfire.ext.metadata.backend.elastic.index.ElasticSearchIndexProvider;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.ext.metadata.model.schema.MetaObject;
import org.uberfire.ext.metadata.model.schema.MetaProperty;

public class ElasticSearchMappingStore {
    private final ElasticSearchIndexProvider indexProvider;

    public ElasticSearchMappingStore(ElasticSearchIndexProvider indexProvider) {
        this.indexProvider = indexProvider;
    }

    public void updateMetaModel(KObject object, MetaObject metaObject) {
        ArrayList<MetaProperty> dirtyProperties = new ArrayList<MetaProperty>();
        Optional<MappingMetaData> mappingOptional = this.indexProvider.getMapping(object.getClusterId(), object.getType().getName());
        if (!mappingOptional.isPresent()) {
            this.indexProvider.putMapping(object.getClusterId(), object.getType().getName(), metaObject);
        } else {
            Map mapping = mappingOptional.get().getSourceAsMap();
            Optional.ofNullable(object.getProperties()).ifPresent(kProperties -> {
                for (KProperty property : object.getProperties()) {
                    Object config = mapping.get(property.getName());
                    if (config != null) continue;
                    Optional prop = metaObject.getProperty(property.getName());
                    prop.ifPresent(metaProperty -> dirtyProperties.add((MetaProperty)metaProperty));
                }
            });
            this.indexProvider.putMapping(object.getClusterId(), object.getType().getName(), dirtyProperties);
        }
    }
}

