/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.elastic.metamodel;

import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.ext.metadata.backend.elastic.index.ElasticSearchIndexProvider;
import org.uberfire.ext.metadata.backend.elastic.metamodel.ElasticSearchMappingStore;
import org.uberfire.ext.metadata.model.schema.MetaProperty;

public class ElasticSearchMappingStoreTest {
    private ElasticSearchMappingStore store;

    @Before
    public void setUp() {
        this.store = new ElasticSearchMappingStore((ElasticSearchIndexProvider)Mockito.mock(ElasticSearchIndexProvider.class));
    }

    @Test
    public void testInspectMappingSingleLevel() {
        String field = "fieldName";
        LinkedHashMap tree = new LinkedHashMap();
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("type", "text");
        attributes.put("analyzer", "simple");
        LinkedHashMap<String, LinkedHashMap<String, String>> properties = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        properties.put(field, attributes);
        tree.put("properties", properties);
        Set metaProps = this.store.inspectTree(Optional.empty(), tree);
        Assert.assertEquals((long)1L, (long)metaProps.size());
        Assert.assertEquals((Object)field, (Object)((MetaProperty)metaProps.iterator().next()).getName());
        Assert.assertEquals(String.class, ((MetaProperty)metaProps.iterator().next()).getTypes().iterator().next());
    }

    @Test
    public void testInspectMappingMultiLevel() {
        String propertiesField = "properties";
        String field = "fieldName";
        String secondLevelFieldName = "secondLevelfieldName";
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("type", "text");
        attributes.put("analyzer", "simple");
        LinkedHashMap<String, LinkedHashMap<String, String>> secondLevelField = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        secondLevelField.put(secondLevelFieldName, attributes);
        LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, String>>> secondLevelProperties = new LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, String>>>();
        secondLevelProperties.put(propertiesField, secondLevelField);
        LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, String>>>> properties = new LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, String>>>>();
        properties.put(field, secondLevelProperties);
        LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, String>>>>> tree = new LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, String>>>>>();
        tree.put(propertiesField, properties);
        Set metaProps = this.store.inspectTree(Optional.empty(), tree);
        Assert.assertEquals((long)1L, (long)metaProps.size());
        Assert.assertEquals((Object)(field + "." + secondLevelFieldName), (Object)((MetaProperty)metaProps.iterator().next()).getName());
        Assert.assertEquals(String.class, ((MetaProperty)metaProps.iterator().next()).getTypes().iterator().next());
    }

    @Test
    public void testConvertType() {
        Assert.assertEquals(String.class, (Object)this.store.convertType("text"));
        Assert.assertEquals(String.class, (Object)this.store.convertType("keyword"));
        Assert.assertEquals(String.class, (Object)this.store.loadClass("string"));
        Assert.assertEquals(Long.class, (Object)this.store.loadClass("long"));
        Assert.assertEquals(Integer.class, (Object)this.store.loadClass("integer"));
    }
}

