/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.elastic.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.metadata.model.schema.MetaObject;
import org.uberfire.ext.metadata.model.schema.MetaProperty;
import org.uberfire.ext.metadata.model.schema.MetaType;

public class ElasticMetaObject
implements MetaObject {
    private MetaType type;
    private List<MetaProperty> properties;

    public ElasticMetaObject(MetaType type) {
        PortablePreconditions.checkNotNull((String)"type", (Object)type);
        PortablePreconditions.checkNotEmpty((String)"type.name", (String)type.getName());
        this.type = type;
        this.properties = new ArrayList<MetaProperty>();
    }

    public MetaType getType() {
        return this.type;
    }

    public Collection<MetaProperty> getProperties() {
        return this.properties;
    }

    public Optional<MetaProperty> getProperty(String name) {
        PortablePreconditions.checkNotEmpty((String)"name", (String)name);
        return this.properties.stream().filter(metaProperty -> metaProperty.getName().equals(name)).findAny();
    }

    public void addProperty(MetaProperty metaProperty) {
        this.properties.add(metaProperty);
    }
}

