/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.elastic.index;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.client.transport.TransportClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.metadata.backend.elastic.index.ElasticSearchIndexProvider;
import org.uberfire.ext.metadata.backend.elastic.metamodel.ElasticMetaObject;
import org.uberfire.ext.metadata.backend.elastic.metamodel.ElasticMetaProperty;
import org.uberfire.ext.metadata.backend.elastic.provider.ElasticSearchContext;
import org.uberfire.ext.metadata.engine.MetaModelStore;
import org.uberfire.ext.metadata.metamodel.NullMetaModelStore;
import org.uberfire.ext.metadata.model.schema.MetaProperty;

@RunWith(value=MockitoJUnitRunner.class)
public class ElasticSearchIndexProviderTest {
    private ElasticSearchIndexProvider provider;
    @Mock
    private ElasticSearchContext elasticSearchContext;
    @Mock
    private Analyzer analyzer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private TransportClient transportClient;

    @Before
    public void setUp() {
        this.provider = (ElasticSearchIndexProvider)Mockito.spy((Object)new ElasticSearchIndexProvider((MetaModelStore)new NullMetaModelStore(), this.elasticSearchContext, this.analyzer));
        ((ElasticSearchIndexProvider)Mockito.doReturn((Object)this.transportClient).when((Object)this.provider)).getClient();
    }

    @Test
    public void testEscapeSpecialCharacters() {
        String expected = "(+field:value AND +field2:\\+AAA123=) OR url:\"git\\:\\/\\/main@path\\/to\\/file\"";
        String queryString = "(+field:value AND +field2:+AAA123=) OR url:git://main@path/to/file";
        String escapedQueryString = this.provider.escapeSpecialCharacters(queryString);
        Assert.assertEquals((Object)expected, (Object)escapedQueryString);
    }

    @Test
    public void testCreateElasticTypeKeyword() {
        ElasticMetaProperty metaProperty = new ElasticMetaProperty("field", "value", new HashSet<Class>(Arrays.asList(String.class)));
        String type = this.provider.createElasticType((MetaProperty)metaProperty);
        Assert.assertEquals((Object)"keyword", (Object)type);
    }

    @Test
    public void testCreateElasticTypeText() {
        ElasticMetaProperty metaProperty = new ElasticMetaProperty("field", "value", new HashSet<Class>(Arrays.asList(String.class)), false, true);
        String type = this.provider.createElasticType((MetaProperty)metaProperty);
        Assert.assertEquals((Object)"text", (Object)type);
    }

    @Test
    public void testCreateElasticTypeOther() {
        ElasticMetaProperty metaProperty = new ElasticMetaProperty("field", "1", new HashSet<Class>(Arrays.asList(Integer.class)), false, true);
        String type = this.provider.createElasticType((MetaProperty)metaProperty);
        Assert.assertEquals((Object)"integer", (Object)type);
    }

    @Test
    public void testPrepareIndex() {
        String index = this.provider.sanitizeIndex("system_ou/plugins");
        Assert.assertEquals((Object)"system_ou_plugins", (Object)index);
    }

    @Test
    public void testCreateIndexRequest() {
        ElasticMetaObject obj = new ElasticMetaObject(() -> "type");
        obj.addProperty((MetaProperty)new ElasticMetaProperty("cluster.id", "system_ou/plugins", (Set)Sets.newHashSet((Object[])new Class[]{String.class})));
        obj.addProperty((MetaProperty)new ElasticMetaProperty("type", "plugins", (Set)Sets.newHashSet((Object[])new Class[]{String.class})));
        this.provider.createIndexRequest(obj);
        ((TransportClient)Mockito.verify((Object)this.transportClient)).prepareIndex((String)Mockito.eq((Object)"system_ou_plugins"), (String)Mockito.eq((Object)"plugins"));
    }
}

